/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.task;

import java.io.File;
import java.io.FileOutputStream;
import org.apache.ddlutils.Platform;
import org.apache.ddlutils.io.DataWriter;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.Table;
import org.apache.ddlutils.task.DatabaseCommand;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class WriteDataToFileCommand
extends DatabaseCommand {
    private File _outputFile;
    private String _encoding;

    public void setOutputFile(File outputFile) {
        this._outputFile = outputFile;
    }

    public void setEncoding(String encoding) {
        this._encoding = encoding;
    }

    public void execute(Task task, Database model) throws BuildException {
        try {
            Platform platform = this.getPlatform();
            DataWriter writer = new DataWriter(model, new FileOutputStream(this._outputFile), this._encoding);
            writer.writeDocumentStart();
            for (int idx = 0; idx < model.getTableCount(); ++idx) {
                Table table = model.getTable(idx);
                writer.write(platform.query(model, "select * from " + table.getName()));
            }
            writer.writeDocumentEnd();
        }
        catch (Exception ex) {
            throw new BuildException((Throwable)ex);
        }
    }
}

