/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.task;

import java.io.File;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections.set.ListOrderedSet;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class DumpMetadataTask
extends Task {
    private static final String[] IGNORED_PROPERTY_METHODS = new String[]{"getConnection", "getCatalogs"};
    private BasicDataSource _dataSource;
    private File _outputFile = null;
    static /* synthetic */ Class class$java$lang$Object;

    public void addConfiguredDatabase(BasicDataSource dataSource) {
        this._dataSource = dataSource;
    }

    public void setOutputFile(File outputFile) {
        this._outputFile = outputFile;
    }

    public void execute() throws BuildException {
        if (this._dataSource == null) {
            System.out.println("No data source specified, so there is nothing to do.");
            return;
        }
        Connection connection = null;
        try {
            Document document = DocumentFactory.getInstance().createDocument();
            Element root = document.addElement("metadata");
            root.addAttribute("driverClassName", this._dataSource.getDriverClassName());
            connection = this._dataSource.getConnection();
            this.dumpMetaData(root, connection.getMetaData());
            XMLWriter writer = null;
            writer = this._outputFile == null ? new XMLWriter((OutputStream)System.out, OutputFormat.createPrettyPrint()) : new XMLWriter((Writer)new FileWriter(this._outputFile), OutputFormat.createPrettyPrint());
            writer.write(document);
            writer.close();
        }
        catch (Exception ex) {
            throw new BuildException((Throwable)ex);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException ex) {}
            }
        }
    }

    private void dumpMetaData(Element element, DatabaseMetaData metaData) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method[] methods = metaData.getClass().getMethods();
        HashSet<String> filtered = new HashSet<String>(Arrays.asList(IGNORED_PROPERTY_METHODS));
        for (int idx = 0; idx < methods.length; ++idx) {
            if (methods[idx].getParameterTypes().length != 0 || methods[idx].getReturnType() == null || (class$java$lang$Object == null ? DumpMetadataTask.class$("java.lang.Object") : class$java$lang$Object) == methods[idx].getDeclaringClass() || filtered.contains(methods[idx].getName())) continue;
            this.dumpProperty(element, metaData, methods[idx]);
        }
        this.dumpCatalogs(element, metaData);
    }

    private void dumpProperty(Element parent, Object obj, Method propGetter) {
        try {
            this.addProperty(parent, this.getPropertyName(propGetter.getName()), propGetter.invoke(obj, null));
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    private void addProperty(Element element, String name, Object value) {
        if (value != null) {
            if (value.getClass().isArray()) {
                this.addArrayProperty(element, name, (Object[])value);
            } else if (value.getClass().isPrimitive() || value instanceof String) {
                element.addAttribute(name, value.toString());
            } else if (value instanceof ResultSet) {
                this.addResultSetProperty(element, name, (ResultSet)value);
            }
        }
    }

    private void addArrayProperty(Element element, String name, Object[] values) {
        String propName = name;
        if (propName.endsWith("s")) {
            propName = propName.substring(0, propName.length() - 1);
        }
        Element arrayElem = element.addElement(propName + "s");
        for (int idx = 0; idx < values.length; ++idx) {
            this.addProperty(arrayElem, "value", values[idx]);
        }
    }

    private void addResultSetProperty(Element element, String name, ResultSet result) {
        try {
            String propName = name;
            if (propName.endsWith("s")) {
                propName = propName.substring(0, propName.length() - 1);
            }
            Element resultSetElem = element.addElement(propName + "s");
            ResultSetMetaData metaData = result.getMetaData();
            while (result.next()) {
                Element curRow = resultSetElem.addElement(propName);
                for (int idx = 1; idx <= metaData.getColumnCount(); ++idx) {
                    Object value = result.getObject(idx);
                    this.addProperty(curRow, metaData.getColumnLabel(idx), value);
                }
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    private String getPropertyName(String methodName) {
        if (methodName.startsWith("get")) {
            if (Character.isLowerCase(methodName.charAt(4))) {
                return Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4);
            }
            return methodName.substring(3);
        }
        if (methodName.startsWith("is")) {
            if (Character.isLowerCase(methodName.charAt(3))) {
                return Character.toLowerCase(methodName.charAt(2)) + methodName.substring(3);
            }
            return methodName.substring(2);
        }
        return methodName;
    }

    private void dumpCatalogs(Element parent, DatabaseMetaData metaData) {
        Element catalogsElem = parent.addElement("catalogs");
        ArrayList<String> tableTypeList = new ArrayList<String>();
        try {
            ResultSet result = metaData.getTableTypes();
            while (result.next()) {
                tableTypeList.add(result.getString("TABLE_TYPE"));
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        String[] tableTypes = tableTypeList.toArray(new String[tableTypeList.size()]);
        try {
            ResultSet result = metaData.getCatalogs();
            while (result.next()) {
                this.dumpCatalog(catalogsElem, metaData, result.getString("TABLE_CAT"), tableTypes);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    private void dumpCatalog(Element parent, DatabaseMetaData metaData, String catalogName, String[] tableTypes) {
        Element catalogElem = parent.addElement("catalog");
        catalogElem.addAttribute("name", catalogName);
        try {
            ResultSet result = metaData.getTables(catalogName, "%", "%", tableTypes);
            Set columns = this.getColumnsInResultSet(result);
            while (result.next()) {
                Element tableElem = catalogElem.addElement("table");
                String tableName = result.getString("TABLE_NAME");
                if (columns.contains("TABLE_NAME")) {
                    tableElem.addAttribute("name", tableName);
                }
                if (columns.contains("TABLE_CAT")) {
                    tableElem.addAttribute("catalog", result.getString("TABLE_CAT"));
                }
                if (columns.contains("TABLE_SCHEM")) {
                    tableElem.addAttribute("schema", result.getString("TABLE_SCHEM"));
                }
                if (columns.contains("TABLE_TYPE")) {
                    tableElem.addAttribute("type", result.getString("TABLE_TYPE"));
                }
                if (columns.contains("REMARKS")) {
                    tableElem.addAttribute("remarks", result.getString("REMARKS"));
                }
                if (columns.contains("TYPE_NAME")) {
                    tableElem.addAttribute("typeName", result.getString("TYPE_NAME"));
                }
                if (columns.contains("TYPE_CAT")) {
                    tableElem.addAttribute("typeCatalog", result.getString("TYPE_CAT"));
                }
                if (columns.contains("TYPE_SCHEM")) {
                    tableElem.addAttribute("typeSchema", result.getString("TYPE_SCHEM"));
                }
                if (columns.contains("SELF_REFERENCING_COL_NAME")) {
                    tableElem.addAttribute("identifierColumn", result.getString("SELF_REFERENCING_COL_NAME"));
                }
                if (columns.contains("REF_GENERATION")) {
                    tableElem.addAttribute("identifierGeneration", result.getString("REF_GENERATION"));
                }
                this.dumpTable(tableElem, metaData, catalogName, tableName);
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    private void dumpTable(Element tableElem, DatabaseMetaData metaData, String catalogName, String tableName) {
        try {
            ResultSet result = metaData.getColumns(catalogName, "%", tableName, "%");
            Set columns = this.getColumnsInResultSet(result);
            while (result.next()) {
                Element columnElem = tableElem.addElement("column");
                String columnName = result.getString("COLUMN_NAME");
                if (columns.contains("COLUMN_NAME")) {
                    columnElem.addAttribute("name", columnName);
                }
                if (columns.contains("DATA_TYPE")) {
                    columnElem.addAttribute("typeCode", String.valueOf(result.getInt("DATA_TYPE")));
                }
                if (columns.contains("TYPE_NAME")) {
                    columnElem.addAttribute("type", result.getString("TYPE_NAME"));
                }
                if (columns.contains("COLUMN_SIZE")) {
                    columnElem.addAttribute("size", String.valueOf(result.getInt("COLUMN_SIZE")));
                }
                if (columns.contains("DECIMAL_DIGITS")) {
                    columnElem.addAttribute("digits", String.valueOf(result.getInt("DECIMAL_DIGITS")));
                }
                if (columns.contains("NUM_PREC_RADIX")) {
                    columnElem.addAttribute("precision", String.valueOf(result.getInt("NUM_PREC_RADIX")));
                }
                if (columns.contains("NULLABLE")) {
                    switch (result.getInt("NULLABLE")) {
                        case 0: {
                            columnElem.addAttribute("nullable", "false");
                            break;
                        }
                        case 1: {
                            columnElem.addAttribute("nullable", "true");
                            break;
                        }
                        default: {
                            columnElem.addAttribute("nullable", "unknown");
                        }
                    }
                }
                if (columns.contains("REMARKS")) {
                    columnElem.addAttribute("remarks", result.getString("REMARKS"));
                }
                if (columns.contains("COLUMN_DEF")) {
                    columnElem.addAttribute("defaultValue", result.getString("COLUMN_DEF"));
                }
                if (columns.contains("CHAR_OCTET_LENGTH")) {
                    columnElem.addAttribute("maxByteLength", String.valueOf(result.getInt("CHAR_OCTET_LENGTH")));
                }
                if (columns.contains("ORDINAL_POSITION")) {
                    columnElem.addAttribute("index", String.valueOf(result.getInt("ORDINAL_POSITION")));
                }
                if (columns.contains("IS_NULLABLE")) {
                    String value = result.getString("IS_NULLABLE");
                    if ("no".equalsIgnoreCase(value)) {
                        columnElem.addAttribute("isNullable", "false");
                    } else if ("yes".equalsIgnoreCase(value)) {
                        columnElem.addAttribute("isNullable", "true");
                    } else {
                        columnElem.addAttribute("isNullable", "unknown");
                    }
                }
                if (columns.contains("SCOPE_CATLOG")) {
                    columnElem.addAttribute("refCatalog", result.getString("SCOPE_CATLOG"));
                }
                if (columns.contains("SCOPE_SCHEMA")) {
                    columnElem.addAttribute("refSchema", result.getString("SCOPE_SCHEMA"));
                }
                if (columns.contains("SCOPE_TABLE")) {
                    columnElem.addAttribute("refTable", result.getString("SCOPE_TABLE"));
                }
                if (!columns.contains("SOURCE_DATA_TYPE")) continue;
                columnElem.addAttribute("sourceTypeCode", String.valueOf(result.getShort("SOURCE_DATA_TYPE")));
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    private Set getColumnsInResultSet(ResultSet resultSet) throws SQLException {
        ListOrderedSet result = new ListOrderedSet();
        ResultSetMetaData metaData = resultSet.getMetaData();
        for (int idx = 1; idx <= metaData.getColumnCount(); ++idx) {
            result.add((Object)metaData.getColumnName(idx).toUpperCase());
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

