/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.task;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.ddlutils.io.JdbcModelReader;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.task.DatabaseTaskBase;
import org.apache.ddlutils.task.WriteDataToDatabaseCommand;
import org.apache.ddlutils.task.WriteDtdToFileCommand;
import org.apache.ddlutils.task.WriteSchemaSqlToFileCommand;
import org.apache.ddlutils.task.WriteSchemaToFileCommand;
import org.apache.tools.ant.BuildException;

public class DatabaseToDdlTask
extends DatabaseTaskBase {
    private String _schema;
    private String _catalog;
    private String _tableTypes;

    public void setSchema(String schema) {
        this._schema = schema;
    }

    public void setCatalog(String catalog) {
        this._catalog = catalog;
    }

    public void setTableTypes(String tableTypes) {
        this._tableTypes = tableTypes;
    }

    public void addWriteDtdToFile(WriteDtdToFileCommand command) {
        this.addCommand(command);
    }

    public void addWriteSchemaToFile(WriteSchemaToFileCommand command) {
        this.addCommand(command);
    }

    public void addWriteSchemaSqlToFile(WriteSchemaSqlToFileCommand command) {
        this.addCommand(command);
    }

    public void addWriteDataToDatabase(WriteDataToDatabaseCommand command) {
        this.addCommand(command);
    }

    private String[] getTableTypes() {
        if (this._tableTypes == null || this._tableTypes.length() == 0) {
            return new String[0];
        }
        StringTokenizer tokenizer = new StringTokenizer(this._tableTypes, ",");
        ArrayList<String> result = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken().trim();
            if (token.length() <= 0) continue;
            result.add(token);
        }
        return result.toArray(new String[result.size()]);
    }

    private Database readSchema() {
        if (this.getDataSource() == null) {
            throw new BuildException("No database specified.");
        }
        try {
            String[] tableTypes;
            JdbcModelReader reader = new JdbcModelReader(this.getDataSource().getConnection());
            if (this._catalog != null && this._catalog.length() > 0) {
                reader.setCatalog(this._catalog);
            }
            if (this._schema != null && this._schema.length() > 0) {
                reader.setSchema(this._schema);
            }
            if ((tableTypes = this.getTableTypes()).length > 0) {
                reader.setTableTypes(tableTypes);
            }
            return reader.getDatabase();
        }
        catch (Exception ex) {
            throw new BuildException("Could not read the schema from the specified database: " + ex.getLocalizedMessage(), (Throwable)ex);
        }
    }

    public void execute() throws BuildException {
        if (!this.hasCommands()) {
            this.log("No sub tasks specified, so there is nothing to do.", 2);
            return;
        }
        Database model = this.readSchema();
        if (model == null) {
            this.log("No schemas read, so there is nothing to do.", 2);
            return;
        }
        this.executeCommands(model);
    }
}

