/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.task;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.task.Command;
import org.apache.ddlutils.task.DatabaseCommand;
import org.apache.tools.ant.Task;

public abstract class DatabaseTaskBase
extends Task {
    private String _databaseType;
    private BasicDataSource _dataSource;
    private ArrayList _commands = new ArrayList();

    public String getDatabaseType() {
        return this._databaseType;
    }

    public void setDatabaseType(String type) {
        this._databaseType = type;
    }

    public BasicDataSource getDataSource() {
        return this._dataSource;
    }

    public void addConfiguredDatabase(BasicDataSource dataSource) {
        this._dataSource = dataSource;
    }

    protected void addCommand(Command command) {
        this._commands.add(command);
    }

    protected boolean hasCommands() {
        return !this._commands.isEmpty();
    }

    protected void executeCommands(Database model) {
        Iterator it = this._commands.iterator();
        while (it.hasNext()) {
            Command cmd = (Command)it.next();
            if (cmd instanceof DatabaseCommand) {
                ((DatabaseCommand)cmd).setDatabaseInfo(this.getDataSource(), this.getDatabaseType());
            }
            cmd.execute(this, model);
        }
    }
}

