/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.task;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.ddlutils.Platform;
import org.apache.ddlutils.PlatformFactory;
import org.apache.ddlutils.PlatformUtils;
import org.apache.ddlutils.task.Command;
import org.apache.ddlutils.task.Parameter;
import org.apache.tools.ant.BuildException;

public abstract class DatabaseCommand
implements Command {
    private String _databaseType;
    private BasicDataSource _dataSource;
    private boolean _failOnError = true;
    private boolean _useDelimitedSqlIdentifiers = true;
    private ArrayList _parameters = new ArrayList();

    protected String getDatabaseType() {
        return this._databaseType;
    }

    protected BasicDataSource getDataSource() {
        return this._dataSource;
    }

    protected void setDatabaseInfo(BasicDataSource dataSource, String type) {
        this._dataSource = dataSource;
        this._databaseType = type;
    }

    public boolean isFailOnError() {
        return this._failOnError;
    }

    public void setFailOnError(boolean failOnError) {
        this._failOnError = failOnError;
    }

    public boolean isUseDelimitedSqlIdentifiers() {
        return this._useDelimitedSqlIdentifiers;
    }

    public void setUseDelimitedSqlIdentifiers(boolean useDelimitedSqlIdentifiers) {
        this._useDelimitedSqlIdentifiers = useDelimitedSqlIdentifiers;
    }

    protected Platform getPlatform() throws BuildException {
        Platform platform = null;
        if (this._databaseType == null) {
            if (this._dataSource == null) {
                throw new BuildException("No database specified.");
            }
            if (this._databaseType == null) {
                this._databaseType = new PlatformUtils().determineDatabaseType(this._dataSource.getDriverClassName(), this._dataSource.getUrl());
            }
            if (this._databaseType == null) {
                this._databaseType = new PlatformUtils().determineDatabaseType((DataSource)this._dataSource);
            }
        }
        try {
            platform = PlatformFactory.createNewPlatformInstance(this._databaseType);
        }
        catch (Exception ex) {
            throw new BuildException("Database type " + this._databaseType + " is not supported.", (Throwable)ex);
        }
        if (platform == null) {
            throw new BuildException("Database type " + this._databaseType + " is not supported.");
        }
        platform.setDataSource((DataSource)this._dataSource);
        platform.getPlatformInfo().setUseDelimitedIdentifiers(this.isUseDelimitedSqlIdentifiers());
        return platform;
    }

    public void addConfiguredParameter(Parameter param) {
        this._parameters.add(param);
    }

    Map getFilteredParameters(String platformName) {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        Iterator it = this._parameters.iterator();
        while (it.hasNext()) {
            Parameter param = (Parameter)it.next();
            if (!param.isForPlatform(platformName)) continue;
            parameters.put(param.getName(), param.getValue());
        }
        return parameters;
    }
}

