/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.task;

import org.apache.commons.dbcp.BasicDataSource;
import org.apache.ddlutils.Platform;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.task.DatabaseCommand;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class CreateDatabaseCommand
extends DatabaseCommand {
    public void execute(Task task, Database model) throws BuildException {
        BasicDataSource dataSource = this.getDataSource();
        if (dataSource == null) {
            throw new BuildException("No database specified.");
        }
        Platform platform = this.getPlatform();
        try {
            platform.createDatabase(dataSource.getDriverClassName(), dataSource.getUrl(), dataSource.getUsername(), dataSource.getPassword(), this.getFilteredParameters(platform.getName()));
            task.log("Created database", 2);
        }
        catch (UnsupportedOperationException ex) {
            task.log("Database platform " + this.getPlatform().getName() + " does not support database creation via JDBC", 0);
        }
        catch (Exception ex) {
            if (this.isFailOnError()) {
                throw new BuildException((Throwable)ex);
            }
            task.log(ex.getLocalizedMessage(), 0);
        }
    }
}

