/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.platform;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.Map;
import org.apache.ddlutils.DynaSqlException;
import org.apache.ddlutils.PlatformInfo;
import org.apache.ddlutils.builder.PostgreSqlBuilder;
import org.apache.ddlutils.platform.PlatformImplBase;

public class PostgreSqlPlatform
extends PlatformImplBase {
    public static final String DATABASENAME = "PostgreSql";
    public static final String JDBC_DRIVER = "org.postgresql.Driver";
    public static final String JDBC_SUBPROTOCOL = "postgresql";

    public PostgreSqlPlatform() {
        PlatformInfo info = new PlatformInfo();
        info.setMaxIdentifierLength(31);
        info.setRequiringNullAsDefaultValue(false);
        info.setPrimaryKeyEmbedded(true);
        info.setForeignKeysEmbedded(false);
        info.setIndicesEmbedded(false);
        info.addNativeTypeMapping(2003, "BYTEA");
        info.addNativeTypeMapping(-2, "BYTEA");
        info.addNativeTypeMapping(-7, "BOOLEAN");
        info.addNativeTypeMapping(2004, "BYTEA");
        info.addNativeTypeMapping(2005, "TEXT");
        info.addNativeTypeMapping(3, "NUMERIC");
        info.addNativeTypeMapping(2001, "BYTEA");
        info.addNativeTypeMapping(8, "DOUBLE PRECISION");
        info.addNativeTypeMapping(6, "DOUBLE PRECISION");
        info.addNativeTypeMapping(2000, "BYTEA");
        info.addNativeTypeMapping(-4, "BYTEA");
        info.addNativeTypeMapping(-1, "TEXT");
        info.addNativeTypeMapping(0, "BYTEA");
        info.addNativeTypeMapping(1111, "BYTEA");
        info.addNativeTypeMapping(2006, "BYTEA");
        info.addNativeTypeMapping(2002, "BYTEA");
        info.addNativeTypeMapping(-6, "SMALLINT");
        info.addNativeTypeMapping(-3, "BYTEA");
        info.addNativeTypeMapping("DATALINK", "BYTEA");
        info.setHasSize(-2, false);
        info.setHasSize(-3, false);
        this.setSqlBuilder(new PostgreSqlBuilder(info));
    }

    public String getName() {
        return DATABASENAME;
    }

    private void createOrDropDatabase(String jdbcDriverClassName, String connectionUrl, String username, String password, Map parameters, boolean createDb) throws DynaSqlException, UnsupportedOperationException {
        if (JDBC_DRIVER.equals(jdbcDriverClassName)) {
            int slashPos = connectionUrl.lastIndexOf(47);
            if (slashPos < 0) {
                throw new DynaSqlException("Cannot parse the given connection url " + connectionUrl);
            }
            int paramPos = connectionUrl.lastIndexOf(63);
            String baseDb = connectionUrl.substring(0, slashPos + 1) + "template1";
            String dbName = paramPos > slashPos ? connectionUrl.substring(slashPos + 1, paramPos) : connectionUrl.substring(slashPos + 1);
            Connection connection = null;
            Statement stmt = null;
            StringBuffer sql = new StringBuffer();
            sql.append(createDb ? "CREATE" : "DROP");
            sql.append(" DATABASE ");
            sql.append(dbName);
            if (parameters != null && !parameters.isEmpty()) {
                Iterator it = parameters.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    sql.append(" ");
                    sql.append(entry.getKey().toString());
                    if (entry.getValue() == null) continue;
                    sql.append(" ");
                    sql.append(entry.getValue().toString());
                }
            }
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((Object)("About to create database via " + baseDb + " using this SQL: " + sql.toString()));
            }
            try {
                Class.forName(jdbcDriverClassName);
                connection = DriverManager.getConnection(baseDb, username, password);
                stmt = connection.createStatement();
                stmt.execute(sql.toString());
                this.logWarnings(connection);
            }
            catch (Exception ex) {
                throw new DynaSqlException("Error while trying to " + (createDb ? "create" : "drop") + " a database: " + ex.getLocalizedMessage(), ex);
            }
            finally {
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException ex) {}
                }
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException ex) {}
                }
            }
        }
        throw new UnsupportedOperationException("Unable to " + (createDb ? "create" : "drop") + " a PostgreSQL database via the driver " + jdbcDriverClassName);
    }

    public void createDatabase(String jdbcDriverClassName, String connectionUrl, String username, String password, Map parameters) throws DynaSqlException, UnsupportedOperationException {
        this.createOrDropDatabase(jdbcDriverClassName, connectionUrl, username, password, parameters, true);
    }

    public void dropDatabase(String jdbcDriverClassName, String connectionUrl, String username, String password) throws DynaSqlException, UnsupportedOperationException {
        this.createOrDropDatabase(jdbcDriverClassName, connectionUrl, username, password, null, false);
    }
}

