/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.platform;

import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ddlutils.DynaSqlException;
import org.apache.ddlutils.Platform;
import org.apache.ddlutils.PlatformInfo;
import org.apache.ddlutils.builder.SqlBuilder;
import org.apache.ddlutils.dynabean.DynaSqlIterator;
import org.apache.ddlutils.dynabean.SqlDynaClass;
import org.apache.ddlutils.dynabean.SqlDynaProperty;
import org.apache.ddlutils.io.JdbcModelReader;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.Table;
import org.apache.ddlutils.util.JdbcSupport;

public abstract class PlatformImplBase
extends JdbcSupport
implements Platform {
    private final Log _log = LogFactory.getLog(this.getClass());
    private SqlBuilder _builder;

    public SqlBuilder getSqlBuilder() {
        return this._builder;
    }

    protected void setSqlBuilder(SqlBuilder builder) {
        this._builder = builder;
    }

    public PlatformInfo getPlatformInfo() {
        return this._builder.getPlatformInfo();
    }

    protected Log getLog() {
        return this._log;
    }

    protected void logWarnings(Connection connection) throws SQLException {
        for (SQLWarning warning = connection.getWarnings(); warning != null; warning = warning.getNextWarning()) {
            this.getLog().warn((Object)warning.getLocalizedMessage(), warning.getCause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int evaluateBatch(String sql, boolean continueOnError) throws DynaSqlException {
        Connection connection = this.borrowConnection();
        try {
            int n = this.evaluateBatch(connection, sql, continueOnError);
            return n;
        }
        finally {
            this.returnConnection(connection);
        }
    }

    public int evaluateBatch(Connection connection, String sql, boolean continueOnError) throws DynaSqlException {
        Statement statement = null;
        int errors = 0;
        int commandCount = 0;
        try {
            statement = connection.createStatement();
            StringTokenizer tokenizer = new StringTokenizer(sql, ";");
            while (tokenizer.hasMoreTokens()) {
                String command = tokenizer.nextToken();
                if ((command = command.trim()).length() == 0) continue;
                ++commandCount;
                if (this._log.isDebugEnabled()) {
                    this._log.debug((Object)("About to execute SQL " + command));
                }
                try {
                    int results = statement.executeUpdate(command);
                    if (this._log.isDebugEnabled()) {
                        this._log.debug((Object)("After execution, " + results + " row(s) have been changed"));
                    }
                }
                catch (SQLException ex) {
                    if (continueOnError) {
                        System.err.println("SQL Command " + command + " failed with " + ex.getMessage());
                        ++errors;
                    }
                    throw new DynaSqlException("Error while executing SQL " + command, ex);
                }
                for (SQLWarning warning = connection.getWarnings(); warning != null; warning = warning.getNextWarning()) {
                    this._log.warn((Object)warning.toString());
                }
                connection.clearWarnings();
            }
            this._log.info((Object)("Executed " + commandCount + " SQL command(s) with " + errors + " error(s)"));
        }
        catch (SQLException ex) {
            throw new DynaSqlException("Error while executing SQL", ex);
        }
        finally {
            this.closeStatement(statement);
        }
        return errors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTables(Database model, boolean dropTablesFirst, boolean continueOnError) throws DynaSqlException {
        Connection connection = this.borrowConnection();
        try {
            this.createTables(connection, model, dropTablesFirst, continueOnError);
        }
        finally {
            this.returnConnection(connection);
        }
    }

    public void createDatabase(String jdbcDriverClassName, String connectionUrl, String username, String password, Map parameters) throws DynaSqlException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Database creation is not supported for the database platform " + this.getName());
    }

    public void dropDatabase(String jdbcDriverClassName, String connectionUrl, String username, String password) throws DynaSqlException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Database deletion is not supported for the database platform " + this.getName());
    }

    public void createTables(Connection connection, Database model, boolean dropTablesFirst, boolean continueOnError) throws DynaSqlException {
        String sql = null;
        try {
            StringWriter buffer = new StringWriter();
            this.getSqlBuilder().setWriter(buffer);
            this.getSqlBuilder().createTables(model, dropTablesFirst, null);
            sql = buffer.toString();
        }
        catch (IOException e) {
            // empty catch block
        }
        this.evaluateBatch(connection, sql, continueOnError);
    }

    public void alterTables(Database desiredDb, boolean continueOnError) throws DynaSqlException {
        this.alterTables(desiredDb, false, false, continueOnError);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alterTables(Database desiredDb, boolean doDrops, boolean modifyColumns, boolean continueOnError) throws DynaSqlException {
        Connection connection = this.borrowConnection();
        try {
            this.alterTables(connection, desiredDb, doDrops, modifyColumns, continueOnError);
        }
        finally {
            this.returnConnection(connection);
        }
    }

    public void alterTables(Connection connection, Database desiredModel, boolean doDrops, boolean modifyColumns, boolean continueOnError) throws DynaSqlException {
        String sql = null;
        Database currentModel = null;
        try {
            currentModel = new JdbcModelReader(connection).getDatabase();
        }
        catch (SQLException ex) {
            throw new DynaSqlException("Error while reading the model from the database", ex);
        }
        try {
            StringWriter buffer = new StringWriter();
            this.getSqlBuilder().setWriter(buffer);
            this.getSqlBuilder().alterDatabase(currentModel, desiredModel, doDrops, modifyColumns, null);
            sql = buffer.toString();
        }
        catch (IOException ex) {
            // empty catch block
        }
        this.evaluateBatch(connection, sql, continueOnError);
    }

    public void alterTables(Connection connection, Database desiredDb, boolean continueOnError) throws DynaSqlException {
        this.alterTables(connection, desiredDb, false, false, continueOnError);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropTables(Database model, boolean continueOnError) throws DynaSqlException {
        Connection connection = this.borrowConnection();
        try {
            this.dropTables(connection, model, continueOnError);
        }
        finally {
            this.returnConnection(connection);
        }
    }

    public void dropTables(Connection connection, Database model, boolean continueOnError) throws DynaSqlException {
        String sql = null;
        try {
            StringWriter buffer = new StringWriter();
            this.getSqlBuilder().setWriter(buffer);
            this.getSqlBuilder().dropTables(model);
            sql = buffer.toString();
        }
        catch (IOException e) {
            // empty catch block
        }
        this.evaluateBatch(connection, sql, continueOnError);
    }

    public Iterator query(Database model, String sql) throws DynaSqlException {
        return this.query(model, sql, (Table[])null);
    }

    public Iterator query(Database model, String sql, Collection parameters) throws DynaSqlException {
        return this.query(model, sql, parameters, null);
    }

    public Iterator query(Database model, String sql, Table[] queryHints) throws DynaSqlException {
        Connection connection = this.borrowConnection();
        Statement statement = null;
        ResultSet resultSet = null;
        DynaSqlIterator answer = null;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(sql);
            DynaSqlIterator dynaSqlIterator = answer = this.createResultSetIterator(model, resultSet, queryHints);
            return dynaSqlIterator;
        }
        catch (SQLException ex) {
            throw new DynaSqlException("Error while performing a query", ex);
        }
        finally {
            if (answer == null) {
                this.closeStatement(statement);
                this.returnConnection(connection);
            }
        }
    }

    public Iterator query(Database model, String sql, Collection parameters, Table[] queryHints) throws DynaSqlException {
        Connection connection = this.borrowConnection();
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        DynaSqlIterator answer = null;
        try {
            statement = connection.prepareStatement(sql);
            int paramIdx = 1;
            Iterator iter = parameters.iterator();
            while (iter.hasNext()) {
                statement.setObject(paramIdx, iter.next());
                ++paramIdx;
            }
            resultSet = statement.executeQuery();
            DynaSqlIterator dynaSqlIterator = answer = this.createResultSetIterator(model, resultSet, queryHints);
            return dynaSqlIterator;
        }
        catch (SQLException ex) {
            throw new DynaSqlException("Error while performing a query", ex);
        }
        finally {
            if (answer == null) {
                this.closeStatement(statement);
                this.returnConnection(connection);
            }
        }
    }

    public List fetch(Database model, String sql) throws DynaSqlException {
        return this.fetch(model, sql, (Table[])null, 0, -1);
    }

    public List fetch(Database model, String sql, Table[] queryHints) throws DynaSqlException {
        return this.fetch(model, sql, queryHints, 0, -1);
    }

    public List fetch(Database model, String sql, int start, int end) throws DynaSqlException {
        return this.fetch(model, sql, (Table[])null, start, end);
    }

    public List fetch(Database model, String sql, Table[] queryHints, int start, int end) throws DynaSqlException {
        Connection connection = this.borrowConnection();
        Statement statement = null;
        ResultSet resultSet = null;
        ArrayList result = new ArrayList();
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(sql);
            DynaSqlIterator it = this.createResultSetIterator(model, resultSet, queryHints);
            for (int rowIdx = 0; (end < 0 || rowIdx <= end) && it.hasNext(); ++rowIdx) {
                if (rowIdx < start) continue;
                result.add(it.next());
            }
        }
        catch (SQLException ex) {
            this.closeStatement(statement);
            this.returnConnection(connection);
            throw new DynaSqlException("Error while fetching data from the database", ex);
        }
        return result;
    }

    public List fetch(Database model, String sql, Collection parameters) throws DynaSqlException {
        return this.fetch(model, sql, parameters, null, 0, -1);
    }

    public List fetch(Database model, String sql, Collection parameters, int start, int end) throws DynaSqlException {
        return this.fetch(model, sql, parameters, null, start, end);
    }

    public List fetch(Database model, String sql, Collection parameters, Table[] queryHints) throws DynaSqlException {
        return this.fetch(model, sql, parameters, queryHints, 0, -1);
    }

    public List fetch(Database model, String sql, Collection parameters, Table[] queryHints, int start, int end) throws DynaSqlException {
        Connection connection = this.borrowConnection();
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        ArrayList result = new ArrayList();
        try {
            statement = connection.prepareStatement(sql);
            int paramIdx = 1;
            Iterator iter = parameters.iterator();
            while (iter.hasNext()) {
                statement.setObject(paramIdx, iter.next());
                ++paramIdx;
            }
            resultSet = statement.executeQuery();
            DynaSqlIterator it = this.createResultSetIterator(model, resultSet, queryHints);
            for (int rowIdx = 0; (end < 0 || rowIdx <= end) && it.hasNext(); ++rowIdx) {
                if (rowIdx < start) continue;
                result.add(it.next());
            }
        }
        catch (SQLException ex) {
            this.closeStatement(statement);
            this.returnConnection(connection);
            throw new DynaSqlException("Error while fetching data from the database", ex);
        }
        return result;
    }

    protected String createInsertSql(Database model, SqlDynaClass dynaClass, SqlDynaProperty[] properties, DynaBean bean) {
        Table table = model.findTable(dynaClass.getTableName());
        HashMap columnValues = this.toColumnValues(properties, bean);
        return this._builder.getInsertSql(table, columnValues, bean == null);
    }

    protected String createSelectLastInsertIdSql(Database model, SqlDynaClass dynaClass) {
        Table table = model.findTable(dynaClass.getTableName());
        return this._builder.getSelectLastInsertId(table);
    }

    public String getInsertSql(Database model, DynaBean dynaBean) {
        SqlDynaClass dynaClass = model.getDynaClassFor(dynaBean);
        SqlDynaProperty[] properties = dynaClass.getSqlDynaProperties();
        if (properties.length == 0) {
            this._log.info((Object)("Cannot insert instances of type " + (Object)((Object)dynaClass) + " because it has no properties"));
            return null;
        }
        return this.createInsertSql(model, dynaClass, properties, dynaBean);
    }

    public void insert(Database model, DynaBean dynaBean, Connection connection) throws DynaSqlException {
        SqlDynaClass dynaClass = model.getDynaClassFor(dynaBean);
        SqlDynaProperty[] properties = dynaClass.getSqlDynaProperties();
        if (properties.length == 0) {
            this._log.warn((Object)("Cannot insert instances of type " + (Object)((Object)dynaClass) + " because it has no properties"));
            return;
        }
        Column[] columns = model.findTable(dynaClass.getTableName()).getAutoIncrementColumn();
        if (columns.length > 0) {
            SqlDynaProperty[] newProperties = new SqlDynaProperty[properties.length - 1];
            int newIdx = 0;
            for (int propIdx = 0; propIdx < properties.length; ++propIdx) {
                for (int autoIncrColumnIdx = 0; autoIncrColumnIdx < columns.length; ++autoIncrColumnIdx) {
                    if (properties[propIdx].getColumn() == columns[autoIncrColumnIdx]) continue;
                    newProperties[newIdx++] = properties[propIdx];
                }
            }
            properties = newProperties;
        }
        String insertSql = this.createInsertSql(model, dynaClass, properties, null);
        String queryIdSql = columns.length > 0 ? this.createSelectLastInsertIdSql(model, dynaClass) : null;
        PreparedStatement statement = null;
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("About to execute SQL: " + insertSql));
        }
        if (columns.length > 0 && queryIdSql == null) {
            this._log.warn((Object)"The database does not support querying for auto-generated pk values");
        }
        try {
            statement = connection.prepareStatement(insertSql);
            for (int idx = 0; idx < properties.length; ++idx) {
                this.setObject(statement, idx + 1, dynaBean, properties[idx]);
            }
            int count = statement.executeUpdate();
            if (count != 1) {
                this._log.warn((Object)("Attempted to insert a single row " + dynaBean + " in table " + dynaClass.getTableName() + " but changed " + count + " row(s)"));
            }
        }
        catch (SQLException ex) {
            throw new DynaSqlException("Error while inserting into the database", ex);
        }
        finally {
            this.closeStatement(statement);
        }
        if (queryIdSql != null) {
            Statement queryStmt = null;
            ResultSet lastInsertedIds = null;
            try {
                connection.commit();
                queryStmt = connection.createStatement();
                lastInsertedIds = queryStmt.executeQuery(queryIdSql);
                lastInsertedIds.next();
                for (int idx = 0; idx < columns.length; ++idx) {
                    Object value = lastInsertedIds.getObject(columns[idx].getName());
                    PropertyUtils.setProperty((Object)dynaBean, (String)columns[idx].getName(), (Object)value);
                }
            }
            catch (NoSuchMethodException ex) {
            }
            catch (IllegalAccessException ex) {
            }
            catch (InvocationTargetException ex) {
            }
            catch (SQLException ex) {
                throw new DynaSqlException("Error while retrieving the auto-generated primary key from the database", ex);
            }
            finally {
                if (lastInsertedIds != null) {
                    try {
                        lastInsertedIds.close();
                    }
                    catch (SQLException ex) {}
                }
                this.closeStatement(statement);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(Database model, DynaBean dynaBean) throws DynaSqlException {
        Connection connection = this.borrowConnection();
        try {
            this.insert(model, dynaBean, connection);
        }
        finally {
            this.returnConnection(connection);
        }
    }

    protected String createUpdateSql(Database model, SqlDynaClass dynaClass, SqlDynaProperty[] primaryKeys, SqlDynaProperty[] properties, DynaBean bean) {
        Table table = model.findTable(dynaClass.getTableName());
        HashMap columnValues = this.toColumnValues(properties, bean);
        return this._builder.getUpdateSql(table, columnValues, bean == null);
    }

    public String getUpdateSql(Database model, DynaBean dynaBean) {
        SqlDynaClass dynaClass = model.getDynaClassFor(dynaBean);
        SqlDynaProperty[] primaryKeys = dynaClass.getPrimaryKeyProperties();
        if (primaryKeys.length == 0) {
            this._log.info((Object)("Cannot update instances of type " + (Object)((Object)dynaClass) + " because it has no primary keys"));
            return null;
        }
        return this.createUpdateSql(model, dynaClass, primaryKeys, dynaClass.getNonPrimaryKeyProperties(), dynaBean);
    }

    public void update(Database model, DynaBean dynaBean, Connection connection) throws DynaSqlException {
        SqlDynaClass dynaClass = model.getDynaClassFor(dynaBean);
        SqlDynaProperty[] primaryKeys = dynaClass.getPrimaryKeyProperties();
        if (primaryKeys.length == 0) {
            this._log.info((Object)("Cannot update instances of type " + (Object)((Object)dynaClass) + " because it has no primary keys"));
            return;
        }
        SqlDynaProperty[] properties = dynaClass.getNonPrimaryKeyProperties();
        String sql = this.createUpdateSql(model, dynaClass, primaryKeys, properties, null);
        PreparedStatement statement = null;
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("About to execute SQL: " + sql));
        }
        try {
            int idx;
            statement = connection.prepareStatement(sql);
            int sqlIndex = 1;
            for (idx = 0; idx < properties.length; ++idx) {
                this.setObject(statement, sqlIndex++, dynaBean, properties[idx]);
            }
            for (idx = 0; idx < properties.length; ++idx) {
                this.setObject(statement, sqlIndex++, dynaBean, primaryKeys[idx]);
            }
            int count = statement.executeUpdate();
            if (count != 1) {
                this._log.warn((Object)("Attempted to insert a single row " + dynaBean + " into table " + dynaClass.getTableName() + " but changed " + count + " row(s)"));
            }
        }
        catch (SQLException ex) {
            throw new DynaSqlException("Error while updating in the database", ex);
        }
        finally {
            this.closeStatement(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Database model, DynaBean dynaBean) throws DynaSqlException {
        Connection connection = this.borrowConnection();
        try {
            this.update(model, dynaBean, connection);
        }
        finally {
            this.returnConnection(connection);
        }
    }

    protected boolean exists(DynaBean dynaBean, Connection connection) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(Database model, DynaBean dynaBean) throws DynaSqlException {
        Connection connection = this.borrowConnection();
        try {
            if (this.exists(dynaBean, connection)) {
                this.update(model, dynaBean, connection);
            } else {
                this.insert(model, dynaBean, connection);
            }
        }
        finally {
            this.returnConnection(connection);
        }
    }

    protected String createDeleteSql(Database model, SqlDynaClass dynaClass, SqlDynaProperty[] primaryKeys, DynaBean bean) {
        Table table = model.findTable(dynaClass.getTableName());
        HashMap pkValues = this.toColumnValues(primaryKeys, bean);
        return this._builder.getDeleteSql(table, pkValues, bean == null);
    }

    public String getDeleteSql(Database model, DynaBean dynaBean) {
        SqlDynaClass dynaClass = model.getDynaClassFor(dynaBean);
        SqlDynaProperty[] primaryKeys = dynaClass.getPrimaryKeyProperties();
        if (primaryKeys.length == 0) {
            this._log.warn((Object)("Cannot delete instances of type " + (Object)((Object)dynaClass) + " because it has no primary keys"));
            return null;
        }
        return this.createDeleteSql(model, dynaClass, primaryKeys, dynaBean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Database model, DynaBean dynaBean) throws DynaSqlException {
        Connection connection = this.borrowConnection();
        try {
            this.delete(model, dynaBean, connection);
        }
        finally {
            this.returnConnection(connection);
        }
    }

    public void delete(Database model, DynaBean dynaBean, Connection connection) throws DynaSqlException {
        PreparedStatement statement = null;
        try {
            SqlDynaClass dynaClass = model.getDynaClassFor(dynaBean);
            SqlDynaProperty[] primaryKeys = dynaClass.getPrimaryKeyProperties();
            if (primaryKeys.length == 0) {
                this._log.warn((Object)("Cannot delete instances of type " + (Object)((Object)dynaClass) + " because it has no primary keys"));
                return;
            }
            String sql = this.createDeleteSql(model, dynaClass, primaryKeys, null);
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("About to execute SQL " + sql));
            }
            statement = connection.prepareStatement(sql);
            for (int idx = 0; idx < primaryKeys.length; ++idx) {
                this.setObject(statement, idx + 1, dynaBean, primaryKeys[idx]);
            }
            int count = statement.executeUpdate();
            if (count != 1) {
                this._log.warn((Object)("Attempted to delete a single row " + dynaBean + " in table " + dynaClass.getTableName() + " but changed " + count + " row(s)."));
            }
            this.closeStatement(statement);
        }
        catch (SQLException ex) {
            throw new DynaSqlException("Error while deleting from the database", ex);
        }
        finally {
            this.closeStatement(statement);
        }
    }

    protected HashMap toColumnValues(SqlDynaProperty[] properties, DynaBean bean) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (int idx = 0; idx < properties.length; ++idx) {
            result.put(properties[idx].getName(), bean == null ? null : bean.get(properties[idx].getName()));
        }
        return result;
    }

    protected void setObject(PreparedStatement statement, int sqlIndex, DynaBean dynaBean, SqlDynaProperty property) throws SQLException {
        int typeCode = property.getColumn().getTypeCode();
        Object value = dynaBean.get(property.getName());
        if (value == null) {
            statement.setNull(sqlIndex, typeCode);
        } else if (value instanceof String) {
            statement.setString(sqlIndex, (String)value);
        } else {
            statement.setObject(sqlIndex, value, typeCode);
        }
    }

    protected DynaSqlIterator createResultSetIterator(Database model, ResultSet resultSet, Table[] queryHints) {
        return new DynaSqlIterator(this.getPlatformInfo(), model, resultSet, queryHints, true);
    }
}

