/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.model;

import java.util.HashMap;
import java.util.HashSet;
import org.apache.ddlutils.util.Jdbc3Utils;

public abstract class TypeMap {
    public static final String ARRAY = "ARRAY";
    public static final String BIGINT = "BIGINT";
    public static final String BINARY = "BINARY";
    public static final String BIT = "BIT";
    public static final String BLOB = "BLOB";
    public static final String BOOLEAN = "BOOLEAN";
    public static final String CHAR = "CHAR";
    public static final String CLOB = "CLOB";
    public static final String DATALINK = "DATALINK";
    public static final String DATE = "DATE";
    public static final String DECIMAL = "DECIMAL";
    public static final String DISTINCT = "DISTINCT";
    public static final String DOUBLE = "DOUBLE";
    public static final String FLOAT = "FLOAT";
    public static final String INTEGER = "INTEGER";
    public static final String JAVA_OBJECT = "JAVA_OBJECT";
    public static final String LONGVARBINARY = "LONGVARBINARY";
    public static final String LONGVARCHAR = "LONGVARCHAR";
    public static final String NULL = "NULL";
    public static final String NUMERIC = "NUMERIC";
    public static final String OTHER = "OTHER";
    public static final String REAL = "REAL";
    public static final String REF = "REF";
    public static final String SMALLINT = "SMALLINT";
    public static final String STRUCT = "STRUCT";
    public static final String TIME = "TIME";
    public static final String TIMESTAMP = "TIMESTAMP";
    public static final String TINYINT = "TINYINT";
    public static final String VARBINARY = "VARBINARY";
    public static final String VARCHAR = "VARCHAR";
    private static HashMap _typeNameToTypeCode = new HashMap();
    private static HashMap _typeCodeToTypeName = new HashMap();
    private static HashSet _numericTypes = new HashSet();
    private static HashSet _textTypes = new HashSet();
    private static HashSet _binaryTypes = new HashSet();
    private static HashSet _specialTypes = new HashSet();

    public static Integer getJdbcTypeCode(String typeName) {
        return (Integer)_typeNameToTypeCode.get(typeName.toUpperCase());
    }

    public static String getJdbcTypeName(int typeCode) {
        return (String)_typeCodeToTypeName.get(new Integer(typeCode));
    }

    protected static void registerJdbcType(int typeCode, String typeName, boolean isNumericType, boolean isTextType, boolean isBinaryType, boolean isSpecialType) {
        Integer typeId = new Integer(typeCode);
        _typeNameToTypeCode.put(typeName.toUpperCase(), typeId);
        _typeCodeToTypeName.put(typeId, typeName.toUpperCase());
        if (isNumericType) {
            _numericTypes.add(typeId);
        }
        if (isTextType) {
            _textTypes.add(typeId);
        }
        if (isBinaryType) {
            _binaryTypes.add(typeId);
        }
        if (isSpecialType) {
            _specialTypes.add(typeId);
        }
    }

    public static boolean isNumericType(int sqlTypeID) {
        return _numericTypes.contains(new Integer(sqlTypeID));
    }

    public static boolean isTextType(int sqlTypeID) {
        return _textTypes.contains(new Integer(sqlTypeID));
    }

    public static boolean isBinaryType(int sqlTypeID) {
        return _binaryTypes.contains(new Integer(sqlTypeID));
    }

    public static boolean isSpecialType(int sqlTypeID) {
        return _specialTypes.contains(new Integer(sqlTypeID));
    }

    static {
        TypeMap.registerJdbcType(2003, ARRAY, false, false, false, true);
        TypeMap.registerJdbcType(-5, BIGINT, true, false, false, false);
        TypeMap.registerJdbcType(-2, BINARY, false, false, true, false);
        TypeMap.registerJdbcType(-7, BIT, true, false, false, false);
        TypeMap.registerJdbcType(2004, BLOB, false, false, true, false);
        TypeMap.registerJdbcType(1, CHAR, false, true, false, false);
        TypeMap.registerJdbcType(2005, CLOB, false, true, false, false);
        TypeMap.registerJdbcType(91, DATE, false, false, false, false);
        TypeMap.registerJdbcType(3, DECIMAL, true, false, false, false);
        TypeMap.registerJdbcType(2001, DISTINCT, false, false, false, true);
        TypeMap.registerJdbcType(8, DOUBLE, true, false, false, false);
        TypeMap.registerJdbcType(6, FLOAT, true, false, false, false);
        TypeMap.registerJdbcType(4, INTEGER, true, false, false, false);
        TypeMap.registerJdbcType(2000, JAVA_OBJECT, false, false, false, true);
        TypeMap.registerJdbcType(-4, LONGVARBINARY, false, false, true, false);
        TypeMap.registerJdbcType(-1, LONGVARCHAR, false, true, false, false);
        TypeMap.registerJdbcType(0, NULL, false, false, false, true);
        TypeMap.registerJdbcType(2, NUMERIC, true, false, false, false);
        TypeMap.registerJdbcType(1111, OTHER, false, false, false, true);
        TypeMap.registerJdbcType(7, REAL, true, false, false, false);
        TypeMap.registerJdbcType(2006, REF, false, false, false, true);
        TypeMap.registerJdbcType(5, SMALLINT, true, false, false, false);
        TypeMap.registerJdbcType(2002, STRUCT, false, false, false, true);
        TypeMap.registerJdbcType(92, TIME, false, false, false, false);
        TypeMap.registerJdbcType(93, TIMESTAMP, false, false, false, false);
        TypeMap.registerJdbcType(-6, TINYINT, true, false, false, false);
        TypeMap.registerJdbcType(-3, VARBINARY, false, false, true, false);
        TypeMap.registerJdbcType(12, VARCHAR, false, true, false, false);
        if (Jdbc3Utils.supportsJava14JdbcTypes()) {
            TypeMap.registerJdbcType(Jdbc3Utils.determineBooleanTypeCode(), BOOLEAN, true, false, false, false);
            TypeMap.registerJdbcType(Jdbc3Utils.determineDatalinkTypeCode(), DATALINK, false, false, false, true);
        }
    }
}

