/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.ForeignKey;
import org.apache.ddlutils.model.Index;

public class Table
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -5541154961302342608L;
    private String _catalog = null;
    private String _schema = null;
    private String _name = null;
    private String _description = null;
    private String _type = null;
    private ArrayList _columns = new ArrayList();
    private ArrayList _foreignKeys = new ArrayList();
    private ArrayList _indices = new ArrayList();

    public String getCatalog() {
        return this._catalog;
    }

    public void setCatalog(String catalog) {
        this._catalog = catalog;
    }

    public String getSchema() {
        return this._schema;
    }

    public void setSchema(String schema) {
        this._schema = schema;
    }

    public String getType() {
        return this._type;
    }

    public void setType(String type) {
        this._type = type;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public int getColumnCount() {
        return this._columns.size();
    }

    public Column getColumn(int idx) {
        return (Column)this._columns.get(idx);
    }

    public Column[] getColumns() {
        return this._columns.toArray(new Column[this._columns.size()]);
    }

    public void addColumn(Column column) {
        if (column != null) {
            this._columns.add(column);
        }
    }

    public void addColumn(int idx, Column column) {
        if (column != null) {
            this._columns.add(idx, column);
        }
    }

    public void removeColumn(Column column) {
        if (column != null) {
            this._columns.remove(column);
        }
    }

    public void removeColumn(int idx) {
        this._columns.remove(idx);
    }

    public int getForeignKeyCount() {
        return this._foreignKeys.size();
    }

    public ForeignKey getForeignKey(int idx) {
        return (ForeignKey)this._foreignKeys.get(idx);
    }

    public ForeignKey[] getForeignKeys() {
        return this._foreignKeys.toArray(new ForeignKey[this._foreignKeys.size()]);
    }

    public void addForeignKey(ForeignKey foreignKey) {
        if (foreignKey != null) {
            this._foreignKeys.add(foreignKey);
        }
    }

    public void addForeignKey(int idx, ForeignKey foreignKey) {
        if (foreignKey != null) {
            this._foreignKeys.add(idx, foreignKey);
        }
    }

    public void removeForeignKey(ForeignKey foreignKey) {
        if (foreignKey != null) {
            this._foreignKeys.remove(foreignKey);
        }
    }

    public void removeForeignKey(int idx) {
        this._foreignKeys.remove(idx);
    }

    public int getIndexCount() {
        return this._indices.size();
    }

    public Index getIndex(int idx) {
        return (Index)this._indices.get(idx);
    }

    public void addIndex(Index index) {
        if (index != null) {
            this._indices.add(index);
        }
    }

    public void addIndex(int idx, Index index) {
        if (index != null) {
            this._indices.add(idx, index);
        }
    }

    public Index[] getIndices() {
        return this._indices.toArray(new Index[this._indices.size()]);
    }

    public Index[] getNonUniqueIndices() {
        Collection nonUniqueIndices = CollectionUtils.select((Collection)this._indices, (Predicate)new Predicate(){

            public boolean evaluate(Object input) {
                return !((Index)input).isUnique();
            }
        });
        return nonUniqueIndices.toArray(new Index[nonUniqueIndices.size()]);
    }

    public Index[] getUniqueIndices() {
        Collection uniqueIndices = CollectionUtils.select((Collection)this._indices, (Predicate)new Predicate(){

            public boolean evaluate(Object input) {
                return ((Index)input).isUnique();
            }
        });
        return uniqueIndices.toArray(new Index[uniqueIndices.size()]);
    }

    public void removeIndex(Index index) {
        if (index != null) {
            this._indices.remove(index);
        }
    }

    public void removeIndex(int idx) {
        this._indices.remove(idx);
    }

    public boolean hasPrimaryKey() {
        Iterator it = this._columns.iterator();
        while (it.hasNext()) {
            Column column = (Column)it.next();
            if (!column.isPrimaryKey()) continue;
            return true;
        }
        return false;
    }

    public Column findColumn(String name) {
        return this.findColumn(name, false);
    }

    public Column findColumn(String name, boolean caseSensitive) {
        Iterator it = this._columns.iterator();
        while (it.hasNext()) {
            Column column = (Column)it.next();
            if (!(caseSensitive ? column.getName().equals(name) : column.getName().equalsIgnoreCase(name))) continue;
            return column;
        }
        return null;
    }

    public Index findIndex(String name) {
        return this.findIndex(name, false);
    }

    public Index findIndex(String name, boolean caseSensitive) {
        for (int idx = 0; idx < this.getIndexCount(); ++idx) {
            Index index = this.getIndex(idx);
            if (!(caseSensitive ? index.getName().equals(name) : index.getName().equalsIgnoreCase(name))) continue;
            return index;
        }
        return null;
    }

    public ForeignKey findForeignKey(ForeignKey key) {
        for (int idx = 0; idx < this.getForeignKeyCount(); ++idx) {
            ForeignKey fk = this.getForeignKey(idx);
            if (!fk.equals(key)) continue;
            return fk;
        }
        return null;
    }

    public Column[] getPrimaryKeyColumns() {
        Collection pkColumns = CollectionUtils.select((Collection)this._columns, (Predicate)new Predicate(){

            public boolean evaluate(Object input) {
                return ((Column)input).isPrimaryKey();
            }
        });
        return pkColumns.toArray(new Column[pkColumns.size()]);
    }

    public Column[] getAutoIncrementColumn() {
        Collection autoIncrColumns = CollectionUtils.select((Collection)this._columns, (Predicate)new Predicate(){

            public boolean evaluate(Object input) {
                return ((Column)input).isAutoIncrement();
            }
        });
        return autoIncrColumns.toArray(new Column[autoIncrColumns.size()]);
    }

    public Object clone() throws CloneNotSupportedException {
        Table result = new Table();
        result._catalog = this._catalog;
        result._schema = this._schema;
        result._name = this._name;
        result._type = this._type;
        result._columns = (ArrayList)this._columns.clone();
        result._foreignKeys = (ArrayList)this._foreignKeys.clone();
        result._indices = (ArrayList)this._indices.clone();
        return result;
    }

    public String toString() {
        return "Table " + this._name + " [" + this._columns.size() + " columns]";
    }
}

