/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.model;

import org.apache.ddlutils.model.Column;

public class Reference
implements Cloneable,
Comparable {
    private Column _localColumn;
    private Column _foreignColumn;
    private String _localColumnName;
    private String _foreignColumnName;

    public Reference() {
    }

    public Reference(Column localColumn, Column foreignColumn) {
        this.setLocalColumn(localColumn);
        this.setForeignColumn(foreignColumn);
    }

    public Column getLocalColumn() {
        return this._localColumn;
    }

    public void setLocalColumn(Column localColumn) {
        this._localColumn = localColumn;
        this._localColumnName = localColumn == null ? null : localColumn.getName();
    }

    public Column getForeignColumn() {
        return this._foreignColumn;
    }

    public void setForeignColumn(Column foreignColumn) {
        this._foreignColumn = foreignColumn;
        this._foreignColumnName = foreignColumn == null ? null : foreignColumn.getName();
    }

    public String getLocalColumnName() {
        return this._localColumnName;
    }

    public void setLocalColumnName(String localColumnName) {
        if (this._localColumn != null && !this._localColumn.getName().equals(localColumnName)) {
            this._localColumn = null;
        }
        this._localColumnName = localColumnName;
    }

    public String getForeignColumnName() {
        return this._foreignColumnName;
    }

    public void setForeignColumnName(String foreignColumnName) {
        if (this._foreignColumn != null && !this._foreignColumn.getName().equals(foreignColumnName)) {
            this._foreignColumn = null;
        }
        this._foreignColumnName = foreignColumnName;
    }

    public Object clone() throws CloneNotSupportedException {
        return new Reference(this.getLocalColumn(), this.getForeignColumn());
    }

    public int compareTo(Object other) {
        Reference ref = (Reference)other;
        int result = this.getLocalColumnName().compareTo(ref.getLocalColumnName());
        if (result == 0) {
            result = this.getForeignColumnName().compareTo(ref.getForeignColumnName());
        }
        return result;
    }

    public boolean equals(Object other) {
        boolean result;
        boolean bl = result = other != null && this.getClass().equals(other.getClass());
        if (result) {
            Reference ref = (Reference)other;
            result = this.getLocalColumnName().equals(ref.getLocalColumnName()) && this.getForeignColumnName().equals(ref.getForeignColumnName());
        }
        return result;
    }

    public String toString() {
        return "Reference[" + this.getLocalColumnName() + " to " + this.getForeignColumnName() + "]";
    }
}

