/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.ddlutils.model.Reference;
import org.apache.ddlutils.model.Table;

public class ForeignKey
implements Cloneable {
    private String _name;
    private Table _foreignTable;
    private String _foreignTableName;
    private ArrayList _references = new ArrayList();

    public ForeignKey() {
        this(null);
    }

    public ForeignKey(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public Table getForeignTable() {
        return this._foreignTable;
    }

    public void setForeignTable(Table foreignTable) {
        this._foreignTable = foreignTable;
        this._foreignTableName = foreignTable == null ? null : foreignTable.getName();
    }

    public String getForeignTableName() {
        return this._foreignTableName;
    }

    public void setForeignTableName(String foreignTableName) {
        if (this._foreignTable != null && !this._foreignTable.getName().equals(foreignTableName)) {
            this._foreignTable = null;
        }
        this._foreignTableName = foreignTableName;
    }

    public int getReferenceCount() {
        return this._references.size();
    }

    public Reference getReference(int idx) {
        return (Reference)this._references.get(idx);
    }

    public Reference[] getReferences() {
        return this._references.toArray(new Reference[this._references.size()]);
    }

    public Reference getFirstReference() {
        return this._references.isEmpty() ? null : this._references.get(0);
    }

    public void addReference(Reference reference) {
        if (reference != null) {
            this._references.add(reference);
        }
    }

    public void addReference(int idx, Reference reference) {
        if (reference != null) {
            this._references.add(idx, reference);
        }
    }

    public void removeReference(Reference reference) {
        if (reference != null) {
            this._references.remove(reference);
        }
    }

    public void removeReference(int idx) {
        this._references.remove(idx);
    }

    public boolean equals(Object other) {
        boolean result;
        boolean bl = result = other != null && this.getClass().equals(other.getClass());
        if (result) {
            ForeignKey fk = (ForeignKey)other;
            boolean bl2 = result = this._foreignTableName.equals(fk._foreignTableName) && this._references.size() == fk._references.size();
            if (result) {
                List copyThis = (List)this._references.clone();
                List copyThat = (List)fk._references.clone();
                Collections.sort(copyThis);
                Collections.sort(copyThat);
                result = ((Object)copyThis).equals(copyThat);
            }
        }
        return result;
    }

    public String toString() {
        return "ForeignKey[" + this._foreignTableName + "]";
    }

    public Object clone() throws CloneNotSupportedException {
        ForeignKey result = new ForeignKey(this._name);
        result._foreignTableName = this._foreignTableName;
        result._references = (ArrayList)this._references.clone();
        return result;
    }
}

