/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.model;

import java.io.Serializable;
import org.apache.ddlutils.model.ModelException;
import org.apache.ddlutils.model.TypeMap;

public class Column
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -6226348998874210093L;
    private String _name;
    private String _javaName;
    private String _description;
    private boolean _primaryKey;
    private boolean _required;
    private boolean _autoIncrement;
    private int _typeCode;
    private String _type;
    private String _size;
    private int _scale = 0;
    private int _precisionRadix = 10;
    private int _ordinalPosition = 0;
    private String _defaultValue;

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getJavaName() {
        return this._javaName;
    }

    public void setJavaName(String javaName) {
        this._javaName = javaName;
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public boolean isPrimaryKey() {
        return this._primaryKey;
    }

    public void setPrimaryKey(boolean primaryKey) {
        this._primaryKey = primaryKey;
    }

    public boolean isRequired() {
        return this._required;
    }

    public void setRequired(boolean required) {
        this._required = required;
    }

    public boolean isAutoIncrement() {
        return this._autoIncrement;
    }

    public void setAutoIncrement(boolean autoIncrement) {
        this._autoIncrement = autoIncrement;
    }

    public int getTypeCode() {
        return this._typeCode;
    }

    public void setTypeCode(int typeCode) {
        this._type = TypeMap.getJdbcTypeName(typeCode);
        if (this._type == null) {
            throw new ModelException("Unknown JDBC type code " + typeCode);
        }
        this._typeCode = typeCode;
    }

    public String getType() {
        return this._type;
    }

    public void setType(String type) {
        Integer typeCode = TypeMap.getJdbcTypeCode(type);
        if (typeCode == null) {
            throw new ModelException("Unknown JDBC type " + type);
        }
        this._typeCode = typeCode;
        this._type = type;
    }

    public boolean isOfNumericType() {
        return TypeMap.isNumericType(this.getTypeCode());
    }

    public boolean isOfTextType() {
        return TypeMap.isTextType(this.getTypeCode());
    }

    public boolean isOfBinaryType() {
        return TypeMap.isBinaryType(this.getTypeCode());
    }

    public boolean isOfSpecialType() {
        return TypeMap.isSpecialType(this.getTypeCode());
    }

    public String getSize() {
        return this._size;
    }

    public int getSizeAsInt() {
        return this._size == null ? 0 : Integer.parseInt(this._size);
    }

    public void setSize(String size) {
        if (size != null) {
            int pos = size.indexOf(",");
            if (pos < 0) {
                this._size = size;
            } else {
                this._size = size.substring(0, pos);
                this._scale = Integer.parseInt(size.substring(pos + 1));
            }
        }
    }

    public int getScale() {
        return this._scale;
    }

    public void setScale(int scale) {
        this._scale = scale;
    }

    public int getPrecisionRadix() {
        return this._precisionRadix;
    }

    public void setPrecisionRadix(int precisionRadix) {
        this._precisionRadix = precisionRadix;
    }

    public int getOrdinalPosition() {
        return this._ordinalPosition;
    }

    public void setOrdinalPosition(int ordinalPosition) {
        this._ordinalPosition = ordinalPosition;
    }

    public String getDefaultValue() {
        return this._defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this._defaultValue = defaultValue;
    }

    public Object clone() throws CloneNotSupportedException {
        Column result = new Column();
        result._name = this._name;
        result._javaName = this._javaName;
        result._primaryKey = this._primaryKey;
        result._required = this._required;
        result._autoIncrement = this._autoIncrement;
        result._typeCode = this._typeCode;
        result._type = this._type;
        result._size = this._size;
        result._defaultValue = this._defaultValue;
        result._scale = this._scale;
        result._precisionRadix = this._precisionRadix;
        result._ordinalPosition = this._ordinalPosition;
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("Column [name=");
        result.append(this.getName());
        result.append("; type=");
        result.append(this.getType());
        result.append("]");
        return result.toString();
    }

    public String toVerboseString() {
        StringBuffer result = new StringBuffer();
        result.append("Column [name=");
        result.append(this.getName());
        result.append("; javaName=");
        result.append(this.getJavaName());
        result.append("; type=");
        result.append(this.getType());
        result.append("; typeCode=");
        result.append(this.getTypeCode());
        result.append("; size=");
        result.append(this.getSize());
        result.append("; required=");
        result.append(this.isRequired());
        result.append("; primaryKey=");
        result.append(this.isPrimaryKey());
        result.append("; autoIncrement=");
        result.append(this.isAutoIncrement());
        result.append("; defaultValue=");
        result.append(this.getDefaultValue());
        result.append("; scale=");
        result.append(this.getScale());
        result.append("; precisionRadix=");
        result.append(this.getPrecisionRadix());
        result.append("; ordinalPosition=");
        result.append(this.getOrdinalPosition());
        result.append("]");
        return result.toString();
    }
}

