/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.io;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.map.LinkedMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.ForeignKey;
import org.apache.ddlutils.model.Index;
import org.apache.ddlutils.model.IndexColumn;
import org.apache.ddlutils.model.NonUniqueIndex;
import org.apache.ddlutils.model.Reference;
import org.apache.ddlutils.model.Table;
import org.apache.ddlutils.model.UniqueIndex;

public class JdbcModelReader {
    private final Log log = LogFactory.getLog((Class)(class$org$apache$ddlutils$io$JdbcModelReader == null ? (class$org$apache$ddlutils$io$JdbcModelReader = JdbcModelReader.class$("org.apache.ddlutils.io.JdbcModelReader")) : class$org$apache$ddlutils$io$JdbcModelReader));
    private HashMap defaultSizes = new HashMap();
    private Connection connection = null;
    private String catalog = "%";
    private String schema = "%";
    private String[] tableTypes = new String[]{"TABLE"};
    private Pattern defaultPattern = Pattern.compile("\\(\\'?(.*?)\\'?\\)");
    static /* synthetic */ Class class$org$apache$ddlutils$io$JdbcModelReader;

    public JdbcModelReader(Connection conn) {
        this.connection = conn;
        this.defaultSizes.put(new Integer(1), "254");
        this.defaultSizes.put(new Integer(12), "254");
        this.defaultSizes.put(new Integer(-1), "254");
        this.defaultSizes.put(new Integer(-2), "254");
        this.defaultSizes.put(new Integer(-3), "254");
        this.defaultSizes.put(new Integer(-4), "254");
        this.defaultSizes.put(new Integer(4), "32");
        this.defaultSizes.put(new Integer(-5), "64");
        this.defaultSizes.put(new Integer(7), "7,0");
        this.defaultSizes.put(new Integer(6), "15,0");
        this.defaultSizes.put(new Integer(8), "15,0");
        this.defaultSizes.put(new Integer(3), "15,15");
        this.defaultSizes.put(new Integer(2), "15,15");
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setTableTypes(String[] types) {
        this.tableTypes = types;
    }

    public Database getDatabase() throws SQLException {
        Database db = new Database();
        Iterator it = this.getTables().iterator();
        while (it.hasNext()) {
            db.addTable((Table)it.next());
        }
        return db;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getTables() throws SQLException {
        ResultSet tableData = null;
        try {
            Table table;
            DatabaseMetaData metaData = this.connection.getMetaData();
            tableData = metaData.getTables(this.catalog, this.schema, "%", this.tableTypes);
            Set availableColumns = this.determineAvailableColumns(tableData);
            ArrayList<Table> tables = new ArrayList<Table>();
            while (tableData.next()) {
                String tableName = this.getValueAsString(tableData, "TABLE_NAME", availableColumns, null);
                if (tableName == null || tableName.length() <= 0) continue;
                table = new Table();
                table.setName(tableName);
                table.setType(this.getValueAsString(tableData, "TABLE_TYPE", availableColumns, "UNKNOWN"));
                table.setCatalog(this.getValueAsString(tableData, "TABLE_CAT", availableColumns, null));
                table.setSchema(this.getValueAsString(tableData, "TABLE_SCHEM", availableColumns, null));
                table.setDescription(this.getValueAsString(tableData, "REMARKS", availableColumns, ""));
                tables.add(table);
            }
            Iterator it = tables.iterator();
            while (it.hasNext()) {
                table = (Table)it.next();
                Iterator columnIt = this.getColumnsForTable(metaData, table.getName()).iterator();
                while (columnIt.hasNext()) {
                    table.addColumn((Column)columnIt.next());
                }
                Iterator fkIt = this.getForeignKeysForTable(metaData, table.getName()).iterator();
                while (fkIt.hasNext()) {
                    table.addForeignKey((ForeignKey)fkIt.next());
                }
                Iterator idxIt = this.getIndicesForTable(metaData, table.getName()).iterator();
                while (idxIt.hasNext()) {
                    table.addIndex((Index)idxIt.next());
                }
            }
            ArrayList<Table> arrayList = tables;
            return arrayList;
        }
        finally {
            if (tableData != null) {
                tableData.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getColumnsForTable(DatabaseMetaData metaData, String tableName) throws SQLException {
        ResultSet columnData = null;
        try {
            columnData = metaData.getColumns(this.catalog, this.schema, tableName, null);
            Set availableColumns = this.determineAvailableColumns(columnData);
            ArrayList<Column> columns = new ArrayList<Column>();
            List primaryKeys = this.getPrimaryKeysForTable(metaData, tableName);
            while (columnData.next()) {
                Column col = new Column();
                col.setName(this.getValueAsString(columnData, "COLUMN_NAME", availableColumns, "UNKNOWN"));
                col.setTypeCode(this.getValueAsInt(columnData, "DATA_TYPE", availableColumns, 1111));
                col.setPrecisionRadix(this.getValueAsInt(columnData, "NUM_PREC_RADIX", availableColumns, 10));
                col.setScale(this.getValueAsInt(columnData, "DECIMAL_DIGITS", availableColumns, 0));
                col.setSize(this.getValueAsString(columnData, "COLUMN_SIZE", availableColumns, (String)this.defaultSizes.get(new Integer(col.getTypeCode()))));
                col.setRequired("NO".equalsIgnoreCase(this.getValueAsString(columnData, "IS_NULLABLE", availableColumns, "YES").trim()));
                if (primaryKeys.contains(col.getName())) {
                    col.setPrimaryKey(true);
                } else {
                    col.setPrimaryKey(false);
                }
                String columnDefaultValue = this.getValueAsString(columnData, "COLUMN_DEF", availableColumns, null);
                if (columnDefaultValue != null) {
                    Matcher m = this.defaultPattern.matcher(columnDefaultValue);
                    if (m.matches()) {
                        columnDefaultValue = m.group(1);
                    }
                    col.setDefaultValue(columnDefaultValue);
                }
                columns.add(col);
            }
            ArrayList<Column> arrayList = columns;
            return arrayList;
        }
        finally {
            if (columnData != null) {
                columnData.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getPrimaryKeysForTable(DatabaseMetaData metaData, String tableName) throws SQLException {
        ArrayList<String> pks = new ArrayList<String>();
        ResultSet pkData = null;
        try {
            pkData = metaData.getPrimaryKeys(this.catalog, this.schema, tableName);
            while (pkData.next()) {
                pks.add(pkData.getString("COLUMN_NAME"));
            }
        }
        catch (SQLException ex) {
            this.log.warn((Object)("Could not determine the primary keys of table " + tableName), (Throwable)ex);
        }
        finally {
            if (pkData != null) {
                pkData.close();
            }
        }
        return pks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getForeignKeysForTable(DatabaseMetaData metaData, String tableName) throws SQLException {
        ArrayList<ForeignKey> fks = new ArrayList<ForeignKey>();
        ResultSet fkData = null;
        try {
            fkData = metaData.getImportedKeys(this.catalog, this.schema, tableName);
            Set availableColumns = this.determineAvailableColumns(fkData);
            String prevPkTable = null;
            ForeignKey currFk = null;
            while (fkData.next()) {
                String pkTable = this.getValueAsString(fkData, "PKTABLE_NAME", availableColumns, null);
                short keySequence = this.getValueAsShort(fkData, "KEY_SEQ", availableColumns, (short)0);
                if (!pkTable.equals(prevPkTable) || keySequence == 1) {
                    if (currFk != null) {
                        fks.add(currFk);
                    }
                    currFk = new ForeignKey(this.getValueAsString(fkData, "FK_NAME", availableColumns, null));
                    currFk.setForeignTableName(pkTable);
                    prevPkTable = pkTable;
                }
                Reference ref = new Reference();
                ref.setForeignColumnName(this.getValueAsString(fkData, "PKCOLUMN_NAME", availableColumns, null));
                ref.setLocalColumnName(this.getValueAsString(fkData, "FKCOLUMN_NAME", availableColumns, null));
                currFk.addReference(ref);
            }
            if (currFk != null) {
                fks.add(currFk);
                currFk = null;
            }
        }
        catch (SQLException ex) {
            this.log.warn((Object)("Could not determine the foreignkeys of table " + tableName), (Throwable)ex);
        }
        finally {
            if (fkData != null) {
                fkData.close();
            }
        }
        return fks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getIndicesForTable(DatabaseMetaData metaData, String tableName) throws SQLException {
        ResultSet indexData = null;
        ArrayList indices = new ArrayList();
        try {
            indexData = metaData.getIndexInfo(this.catalog, this.schema, tableName, false, false);
            Set availableColumns = this.determineAvailableColumns(indexData);
            LinkedMap indicesByName = new LinkedMap();
            while (indexData.next()) {
                String indexName = this.getValueAsString(indexData, "INDEX_NAME", availableColumns, null);
                boolean isUnique = !this.getValueAsBoolean(indexData, "NON_UNIQUE", availableColumns, true);
                Index index = (Index)indicesByName.get(indexName);
                if (index == null && indexName != null) {
                    index = isUnique ? new UniqueIndex() : new NonUniqueIndex();
                    index.setName(indexName);
                    indicesByName.put(indexName, index);
                }
                if (index == null) continue;
                IndexColumn ic = new IndexColumn();
                ic.setName(this.getValueAsString(indexData, "COLUMN_NAME", availableColumns, null));
                index.addColumn(ic);
            }
            indices.addAll(indicesByName.values());
        }
        catch (SQLException ex) {
            this.log.trace((Object)("Could determine the indices for the table " + tableName), (Throwable)ex);
        }
        finally {
            if (indexData != null) {
                indexData.close();
            }
        }
        return indices;
    }

    private Set determineAvailableColumns(ResultSet data) throws SQLException {
        HashSet<String> result = new HashSet<String>();
        ResultSetMetaData metaData = data.getMetaData();
        for (int idx = 1; idx <= metaData.getColumnCount(); ++idx) {
            result.add(metaData.getColumnName(idx).toUpperCase());
        }
        return result;
    }

    private String getValueAsString(ResultSet data, String columnName, Set availableColumns, String defaultValue) throws SQLException {
        return availableColumns.contains(columnName) ? data.getString(columnName) : defaultValue;
    }

    private int getValueAsInt(ResultSet data, String columnName, Set availableColumns, int defaultValue) throws SQLException {
        return availableColumns.contains(columnName) ? data.getInt(columnName) : defaultValue;
    }

    private short getValueAsShort(ResultSet data, String columnName, Set availableColumns, short defaultValue) throws SQLException {
        return availableColumns.contains(columnName) ? data.getShort(columnName) : defaultValue;
    }

    private boolean getValueAsBoolean(ResultSet data, String columnName, Set availableColumns, boolean defaultValue) throws SQLException {
        return availableColumns.contains(columnName) ? data.getBoolean(columnName) : defaultValue;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

