/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.io;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Iterator;
import org.apache.ddlutils.dynabean.SqlDynaBean;
import org.apache.ddlutils.dynabean.SqlDynaClass;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.Table;

public class DataWriter {
    private Database _model;
    private PrintWriter _output;
    private String _encoding;

    public DataWriter(Database model, OutputStream output) {
        this._model = model;
        this._encoding = "UTF-8";
        this._output = new PrintWriter(new OutputStreamWriter(output));
    }

    public DataWriter(Database model, OutputStream output, String encoding) throws UnsupportedEncodingException {
        this._model = model;
        if (encoding == null) {
            this._encoding = "UTF-8";
            this._output = new PrintWriter(new OutputStreamWriter(output));
        } else {
            this._encoding = encoding;
            this._output = new PrintWriter(new OutputStreamWriter(output, encoding));
        }
    }

    public void writeDocumentStart() {
        this._output.println("<?xml version=\"1.0\" encoding=\"" + this._encoding + "\"?>");
        this._output.println("<data>");
    }

    public void writeDocumentEnd() {
        this._output.println("</data>");
    }

    public void write(SqlDynaBean bean) {
        SqlDynaClass dynaClass = (SqlDynaClass)bean.getDynaClass();
        Table table = dynaClass.getTable();
        this._output.println("  <" + table.getName());
        for (int idx = 0; idx < table.getColumnCount(); ++idx) {
            Column column = table.getColumn(idx);
            Object value = bean.get(column.getName());
            if (value == null) continue;
            this._output.println("    " + column.getName() + "=\"" + value.toString() + "\"");
        }
        this._output.println("  >");
    }

    public void write(Iterator beans) {
        while (beans.hasNext()) {
            this.write((SqlDynaBean)((Object)beans.next()));
        }
    }

    public void write(Collection beans) {
        this.write(beans.iterator());
    }
}

