/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.io;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ddlutils.DynaSqlException;
import org.apache.ddlutils.Platform;
import org.apache.ddlutils.dynabean.SqlDynaClass;
import org.apache.ddlutils.io.DataSink;
import org.apache.ddlutils.io.DataSinkException;
import org.apache.ddlutils.io.Identity;
import org.apache.ddlutils.io.WaitingObject;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.ForeignKey;
import org.apache.ddlutils.model.Reference;
import org.apache.ddlutils.model.Table;

public class DataToDatabaseSink
implements DataSink {
    private final Log _log = LogFactory.getLog((Class)(class$org$apache$ddlutils$io$DataToDatabaseSink == null ? (class$org$apache$ddlutils$io$DataToDatabaseSink = DataToDatabaseSink.class$("org.apache.ddlutils.io.DataToDatabaseSink")) : class$org$apache$ddlutils$io$DataToDatabaseSink));
    private Platform _platform;
    private Database _model;
    private Connection _connection;
    private boolean _haltOnErrors = true;
    private boolean _ensureFkOrder = true;
    private HashMap _processedIdentities = new HashMap();
    private ArrayList _waitingObjects = new ArrayList();
    static /* synthetic */ Class class$org$apache$ddlutils$io$DataToDatabaseSink;

    public DataToDatabaseSink(Platform platform, Database model) {
        this._platform = platform;
        this._model = model;
    }

    public boolean isHaltOnErrors() {
        return this._haltOnErrors;
    }

    public void setHaltOnErrors(boolean haltOnErrors) {
        this._haltOnErrors = haltOnErrors;
    }

    public boolean isEnsureFkOrder() {
        return this._ensureFkOrder;
    }

    public void setEnsureFkOrder(boolean ensureFkOrder) {
        this._ensureFkOrder = ensureFkOrder;
    }

    public void end() throws DataSinkException {
        try {
            this._connection.close();
        }
        catch (SQLException ex) {
            throw new DataSinkException(ex);
        }
        if (!this._waitingObjects.isEmpty()) {
            throw new DataSinkException("There are " + this._waitingObjects.size() + " objects still not written because of missing referenced objects");
        }
    }

    public void start() throws DataSinkException {
        this._processedIdentities.clear();
        this._waitingObjects.clear();
        for (int tableIdx = 0; tableIdx < this._model.getTableCount(); ++tableIdx) {
            Table table = this._model.getTable(tableIdx);
            for (int fkIdx = 0; fkIdx < table.getForeignKeyCount(); ++fkIdx) {
                ForeignKey curFk = table.getForeignKey(fkIdx);
                if (this._processedIdentities.containsKey(curFk.getForeignTableName())) continue;
                this._processedIdentities.put(curFk.getForeignTableName(), new HashSet());
            }
        }
        try {
            this._connection = this._platform.borrowConnection();
        }
        catch (DynaSqlException ex) {
            throw new DataSinkException((Throwable)((Object)ex));
        }
    }

    public void addBean(DynaBean bean) throws DataSinkException {
        Table table = this._model.getDynaClassFor(bean).getTable();
        if (table.getForeignKeyCount() > 0) {
            WaitingObject waitingObj = new WaitingObject(bean);
            for (int idx = 0; idx < table.getForeignKeyCount(); ++idx) {
                HashSet identitiesForTable;
                ForeignKey fk = table.getForeignKey(idx);
                Identity fkIdentity = this.buildIdentityFromFK(table, fk, bean);
                if (fkIdentity == null || (identitiesForTable = (HashSet)this._processedIdentities.get(fk.getForeignTableName())).contains(fkIdentity)) continue;
                waitingObj.addPendingFK(fkIdentity);
            }
            if (waitingObj.hasPendingFKs()) {
                if (this._log.isDebugEnabled()) {
                    StringBuffer msg = new StringBuffer();
                    msg.append("Defering insertion of bean ");
                    msg.append(this.buildIdentityFromPKs(table, bean).toString());
                    msg.append(" because it is waiting for:");
                    Iterator it = waitingObj.getPendingFKs();
                    while (it.hasNext()) {
                        msg.append("\n  ");
                        msg.append(it.next().toString());
                    }
                    this._log.debug((Object)msg.toString());
                }
                this._waitingObjects.add(waitingObj);
                return;
            }
        }
        try {
            this._platform.insert(this._model, bean, this._connection);
            if (!this._connection.getAutoCommit()) {
                this._connection.commit();
            }
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("Inserted bean " + this.buildIdentityFromPKs(table, bean).toString()));
            }
        }
        catch (Exception ex) {
            if (this._haltOnErrors) {
                this._platform.returnConnection(this._connection);
                throw new DataSinkException(ex);
            }
            this._log.warn((Object)"Exception while inserting a bean into the database", (Throwable)ex);
        }
        if (this._processedIdentities.containsKey(table.getName())) {
            Identity identity = this.buildIdentityFromPKs(table, bean);
            HashSet identitiesForTable = (HashSet)this._processedIdentities.get(table.getName());
            ArrayList<DynaBean> finishedObjs = new ArrayList<DynaBean>();
            identitiesForTable.add(identity);
            Iterator waitingObjIt = this._waitingObjects.iterator();
            while (waitingObjIt.hasNext()) {
                WaitingObject waitingObj = (WaitingObject)waitingObjIt.next();
                Identity fkIdentity = waitingObj.removePendingFK(identity);
                if (waitingObj.hasPendingFKs()) continue;
                waitingObjIt.remove();
                this.updateFKColumns(waitingObj.getObject(), bean, fkIdentity.getForeignKeyName());
                finishedObjs.add(waitingObj.getObject());
            }
            Iterator finishedObjIt = finishedObjs.iterator();
            while (finishedObjIt.hasNext()) {
                DynaBean finishedObj = (DynaBean)finishedObjIt.next();
                this.addBean(finishedObj);
                if (!this._log.isDebugEnabled()) continue;
                Table waitingObjTable = ((SqlDynaClass)finishedObj.getDynaClass()).getTable();
                this._log.debug((Object)("Inserted deferred bean " + this.buildIdentityFromPKs(waitingObjTable, finishedObj)));
            }
        }
    }

    private String getFKName(Table owningTable, ForeignKey fk) {
        int idx;
        if (fk.getName() != null && fk.getName().length() > 0) {
            return fk.getName();
        }
        StringBuffer result = new StringBuffer();
        result.append(owningTable.getName());
        result.append("[");
        for (idx = 0; idx < fk.getReferenceCount(); ++idx) {
            if (idx > 0) {
                result.append(",");
            }
            result.append(fk.getReference(idx).getLocalColumnName());
        }
        result.append("]->");
        result.append(fk.getForeignTableName());
        result.append("[");
        for (idx = 0; idx < fk.getReferenceCount(); ++idx) {
            if (idx > 0) {
                result.append(",");
            }
            result.append(fk.getReference(idx).getForeignColumnName());
        }
        result.append("]");
        return result.toString();
    }

    private Identity buildIdentityFromPKs(Table table, DynaBean bean) {
        Identity identity = new Identity(table.getName());
        Column[] pkColumns = table.getPrimaryKeyColumns();
        for (int idx = 0; idx < pkColumns.length; ++idx) {
            identity.setIdentityColumn(pkColumns[idx].getName(), bean.get(pkColumns[idx].getName()));
        }
        return identity;
    }

    private Identity buildIdentityFromFK(Table owningTable, ForeignKey fk, DynaBean bean) {
        Identity identity = new Identity(fk.getForeignTableName(), this.getFKName(owningTable, fk));
        for (int idx = 0; idx < fk.getReferenceCount(); ++idx) {
            Reference reference = fk.getReference(idx);
            Object value = bean.get(reference.getLocalColumnName());
            if (value == null) {
                return null;
            }
            identity.setIdentityColumn(reference.getForeignColumnName(), value);
        }
        return identity;
    }

    private void updateFKColumns(DynaBean referencingBean, DynaBean referencedBean, String fkName) {
        int idx;
        Table sourceTable = ((SqlDynaClass)referencingBean.getDynaClass()).getTable();
        Table targetTable = ((SqlDynaClass)referencedBean.getDynaClass()).getTable();
        ForeignKey fk = null;
        for (idx = 0; idx < sourceTable.getForeignKeyCount(); ++idx) {
            ForeignKey curFk = sourceTable.getForeignKey(idx);
            if (!curFk.getForeignTableName().equalsIgnoreCase(targetTable.getName()) || !fkName.equals(this.getFKName(sourceTable, curFk))) continue;
            fk = curFk;
            break;
        }
        if (fk != null) {
            for (idx = 0; idx < fk.getReferenceCount(); ++idx) {
                Reference curRef = fk.getReference(idx);
                Column sourceColumn = sourceTable.findColumn(curRef.getLocalColumnName());
                Column targetColumn = targetTable.findColumn(curRef.getForeignColumnName());
                referencingBean.set(sourceColumn.getName(), referencedBean.get(targetColumn.getName()));
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

