/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.io;

import java.util.HashMap;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.Rules;
import org.apache.ddlutils.io.DataSink;
import org.apache.ddlutils.io.DigesterRules;
import org.apache.ddlutils.io.DynaSqlCreateRule;
import org.apache.ddlutils.io.SetColumnPropertyFromSubElementRule;
import org.apache.ddlutils.io.SetColumnPropertyRule;
import org.apache.ddlutils.io.converters.DateConverter;
import org.apache.ddlutils.io.converters.NumberConverter;
import org.apache.ddlutils.io.converters.SqlTypeConverter;
import org.apache.ddlutils.io.converters.TimeConverter;
import org.apache.ddlutils.io.converters.TimestampConverter;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.Table;
import org.xml.sax.SAXException;

public class DataReader
extends Digester {
    private Database _model;
    private DataSink _sink;
    private boolean _needsConfiguration = true;
    private HashMap _convertersPerType = new HashMap();
    private HashMap _convertersPerPath = new HashMap();
    private boolean _caseSensitive = false;

    public DataReader() {
        NumberConverter numberConverter = new NumberConverter();
        this.registerConverter(91, new DateConverter());
        this.registerConverter(92, new TimeConverter());
        this.registerConverter(93, new TimestampConverter());
        this.registerConverter(-5, numberConverter);
        this.registerConverter(-7, numberConverter);
        this.registerConverter(3, numberConverter);
        this.registerConverter(8, numberConverter);
        this.registerConverter(6, numberConverter);
        this.registerConverter(4, numberConverter);
        this.registerConverter(2, numberConverter);
        this.registerConverter(7, numberConverter);
        this.registerConverter(5, numberConverter);
        this.registerConverter(-6, numberConverter);
    }

    public void registerConverter(int sqlTypeCode, SqlTypeConverter converter) {
        this._convertersPerType.put(new Integer(sqlTypeCode), converter);
    }

    public void registerConverter(String tableName, String columnName, SqlTypeConverter converter) {
        this._convertersPerPath.put(tableName + "/" + columnName, converter);
    }

    public SqlTypeConverter getRegisteredConverter(Table table, Column column) {
        SqlTypeConverter result = (SqlTypeConverter)this._convertersPerPath.get(table.getName() + "/" + column.getName());
        if (result == null) {
            result = (SqlTypeConverter)this._convertersPerType.get(new Integer(column.getTypeCode()));
        }
        return result;
    }

    public Database getModel() {
        return this._model;
    }

    public void setModel(Database model) {
        this._model = model;
        this._needsConfiguration = true;
    }

    public DataSink getSink() {
        return this._sink;
    }

    public void setSink(DataSink sink) {
        this._sink = sink;
        this._needsConfiguration = true;
    }

    public boolean isCaseSensitive() {
        return this._caseSensitive;
    }

    public void setCaseSensitive(boolean beCaseSensitive) {
        this._caseSensitive = beCaseSensitive;
    }

    protected void configure() {
        if (this._needsConfiguration) {
            if (this._model == null) {
                throw new NullPointerException("No database model specified");
            }
            if (this._sink == null) {
                throw new NullPointerException("No data sink model specified");
            }
            DigesterRules rules = new DigesterRules();
            rules.setCaseSensitive(this.isCaseSensitive());
            this.setRules((Rules)rules);
            for (int tableIdx = 0; tableIdx < this._model.getTableCount(); ++tableIdx) {
                Table table = this._model.getTable(tableIdx);
                String path = "data/" + table.getName();
                this.addRule(path, new DynaSqlCreateRule(this._model, table, this._sink));
                for (int columnIdx = 0; columnIdx < table.getColumnCount(); ++columnIdx) {
                    Column column = table.getColumn(columnIdx);
                    SqlTypeConverter converter = this.getRegisteredConverter(table, column);
                    this.addRule(path, new SetColumnPropertyRule(column, converter, this.isCaseSensitive()));
                    this.addRule(path + "/" + column.getName(), new SetColumnPropertyFromSubElementRule(column, converter));
                }
            }
            this._needsConfiguration = false;
        }
        super.configure();
    }

    public void endDocument() throws SAXException {
        super.endDocument();
        this._sink.end();
    }

    public void startDocument() throws SAXException {
        this._sink.start();
        super.startDocument();
    }
}

