/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.dynabean;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.beanutils.BasicDynaClass;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.collections.map.ListOrderedMap;
import org.apache.ddlutils.DynaSqlException;
import org.apache.ddlutils.PlatformInfo;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.Table;

public class DynaSqlIterator
implements Iterator {
    private ResultSet _resultSet;
    private DynaClass _dynaClass;
    private Map _columnsToProperties = new ListOrderedMap();
    private boolean _needsAdvancing = true;
    private boolean _isAtEnd = false;
    private boolean _cleanUpAfterFinish;
    static /* synthetic */ Class class$org$apache$commons$beanutils$BasicDynaBean;

    public DynaSqlIterator(PlatformInfo platformInfo, Database model, ResultSet resultSet, Table[] queryHints, boolean cleanUpAfterFinish) throws DynaSqlException {
        if (resultSet != null) {
            this._resultSet = resultSet;
            this._cleanUpAfterFinish = cleanUpAfterFinish;
            try {
                this.initFromMetaData(platformInfo, model, resultSet, queryHints);
            }
            catch (SQLException ex) {
                this.cleanUp();
                throw new DynaSqlException("Could not read the metadata of the result set", ex);
            }
        } else {
            this._isAtEnd = true;
        }
    }

    private void initFromMetaData(PlatformInfo platformInfo, Database model, ResultSet resultSet, Table[] queryHints) throws SQLException {
        ResultSetMetaData metaData = resultSet.getMetaData();
        String tableName = null;
        boolean singleKnownTable = true;
        boolean caseSensitive = platformInfo.isUseDelimitedIdentifiers();
        Map preparedQueryHints = this.prepareQueryHints(queryHints, caseSensitive);
        for (int idx = 1; idx <= metaData.getColumnCount(); ++idx) {
            Column column;
            String columnName = metaData.getColumnName(idx);
            String tableOfColumn = metaData.getTableName(idx);
            Table table = null;
            if (tableOfColumn != null && tableOfColumn.length() > 0) {
                table = model.findTable(tableOfColumn, caseSensitive);
            } else {
                table = (Table)preparedQueryHints.get(caseSensitive ? columnName : columnName.toLowerCase());
                String string = tableOfColumn = table == null ? null : table.getName();
            }
            if (tableName == null) {
                tableName = tableOfColumn;
            } else if (!tableName.equals(tableOfColumn)) {
                singleKnownTable = false;
            }
            String propName = columnName;
            if (table != null && (column = table.findColumn(columnName, caseSensitive)) != null) {
                propName = column.getName();
            }
            this._columnsToProperties.put(columnName, propName);
        }
        if (singleKnownTable && tableName != null) {
            this._dynaClass = model.getDynaClassFor(tableName);
        } else {
            DynaProperty[] props = new DynaProperty[this._columnsToProperties.size()];
            int idx = 0;
            Iterator it = this._columnsToProperties.values().iterator();
            while (it.hasNext()) {
                props[idx] = new DynaProperty((String)it.next());
                ++idx;
            }
            this._dynaClass = new BasicDynaClass("result", class$org$apache$commons$beanutils$BasicDynaBean == null ? (class$org$apache$commons$beanutils$BasicDynaBean = DynaSqlIterator.class$("org.apache.commons.beanutils.BasicDynaBean")) : class$org$apache$commons$beanutils$BasicDynaBean, props);
        }
    }

    private Map prepareQueryHints(Table[] queryHints, boolean caseSensitive) {
        HashMap<String, Table> result = new HashMap<String, Table>();
        for (int tableIdx = 0; queryHints != null && tableIdx < queryHints.length; ++tableIdx) {
            for (int columnIdx = 0; columnIdx < queryHints[tableIdx].getColumnCount(); ++columnIdx) {
                String columnName = queryHints[tableIdx].getColumn(columnIdx).getName();
                if (caseSensitive) {
                    columnName = columnName.toLowerCase();
                }
                if (result.containsKey(columnName)) continue;
                result.put(columnName, queryHints[tableIdx]);
            }
        }
        return result;
    }

    public boolean hasNext() throws DynaSqlException {
        this.advanceIfNecessary();
        return !this._isAtEnd;
    }

    public Object next() throws DynaSqlException {
        this.advanceIfNecessary();
        if (this._isAtEnd) {
            throw new NoSuchElementException("No more elements in the resultset");
        }
        try {
            DynaBean bean = this._dynaClass.newInstance();
            Iterator it = this._columnsToProperties.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                bean.set((String)entry.getValue(), this._resultSet.getObject((String)entry.getKey()));
            }
            this._needsAdvancing = true;
            return bean;
        }
        catch (Exception ex) {
            this.cleanUp();
            throw new DynaSqlException("Exception while reading the row from the resultset", ex);
        }
    }

    private void advanceIfNecessary() throws DynaSqlException {
        if (this._needsAdvancing && !this._isAtEnd) {
            try {
                this._isAtEnd = !this._resultSet.next();
                this._needsAdvancing = false;
            }
            catch (SQLException ex) {
                this.cleanUp();
                throw new DynaSqlException("Could not retrieve next row from result set", ex);
            }
            if (this._isAtEnd) {
                this.cleanUp();
            }
        }
    }

    public void remove() throws DynaSqlException {
        try {
            this._resultSet.deleteRow();
        }
        catch (SQLException ex) {
            this.cleanUp();
            throw new DynaSqlException("Failed to delete current row", ex);
        }
    }

    public void cleanUp() {
        if (this._cleanUpAfterFinish && this._resultSet != null) {
            try {
                Statement stmt = this._resultSet.getStatement();
                Connection conn = stmt.getConnection();
                stmt.close();
                conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this._resultSet = null;
        }
    }

    protected void finalize() throws Throwable {
        this.cleanUp();
    }

    public boolean isConnectionOpen() {
        if (this._resultSet == null) {
            return false;
        }
        try {
            Statement stmt = this._resultSet.getStatement();
            Connection conn = stmt.getConnection();
            return !conn.isClosed();
        }
        catch (SQLException ex) {
            return false;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

