/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.builder;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.ddlutils.PlatformInfo;
import org.apache.ddlutils.builder.SqlBuilder;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.ForeignKey;
import org.apache.ddlutils.model.Table;

public class SybaseBuilder
extends SqlBuilder {
    public SybaseBuilder(PlatformInfo info) {
        super(info);
    }

    public void createTable(Database database, Table table, Map parameters) throws IOException {
        this.writeQuotationOnStatement();
        super.createTable(database, table, parameters);
    }

    protected void alterTable(Database currentModel, Table currentTable, Database desiredModel, Table desiredTable, boolean doDrops, boolean modifyColumns) throws IOException {
        this.writeQuotationOnStatement();
        super.alterTable(currentModel, currentTable, desiredModel, desiredTable, doDrops, modifyColumns);
    }

    public void dropTable(Table table) throws IOException {
        this.writeQuotationOnStatement();
        this.print("IF EXISTS (SELECT 1 FROM sysobjects WHERE type = 'U' AND name = ");
        this.printAlwaysSingleQuotedIdentifier(this.getTableName(table));
        this.println(")");
        this.println("BEGIN");
        this.printIndent();
        this.print("DROP TABLE ");
        this.printlnIdentifier(this.getTableName(table));
        this.print("END");
        this.printEndOfStatement();
    }

    protected void writeExternalForeignKeyDropStmt(Table table, ForeignKey foreignKey) throws IOException {
        String constraintName = foreignKey.getName() == null ? this.getConstraintName(null, table, "FK", this.getForeignKeyName(foreignKey)) : foreignKey.getName();
        this.print("IF EXISTS (SELECT 1 FROM sysobjects WHERE type = 'RI' AND name = ");
        this.printAlwaysSingleQuotedIdentifier(constraintName);
        this.println(")");
        this.printIndent();
        this.print("ALTER TABLE ");
        this.printIdentifier(this.getTableName(table));
        this.print(" DROP CONSTRAINT ");
        this.printIdentifier(constraintName);
        this.printEndOfStatement();
    }

    public void dropExternalForeignKeys(Table table) throws IOException {
        this.writeQuotationOnStatement();
        super.dropExternalForeignKeys(table);
    }

    private void writeQuotationOnStatement() throws IOException {
        if (this.getPlatformInfo().isUseDelimitedIdentifiers()) {
            this.print("SET quoted_identifier on");
            this.printEndOfStatement();
        }
    }

    public String getDeleteSql(Table table, HashMap pkValues, boolean genPlaceholders) {
        return this.getQuotationOnStatement() + super.getDeleteSql(table, pkValues, genPlaceholders);
    }

    public String getInsertSql(Table table, HashMap columnValues, boolean genPlaceholders) {
        return this.getQuotationOnStatement() + super.getInsertSql(table, columnValues, genPlaceholders);
    }

    public String getUpdateSql(Table table, HashMap columnValues, boolean genPlaceholders) {
        return this.getQuotationOnStatement() + super.getUpdateSql(table, columnValues, genPlaceholders);
    }

    private String getQuotationOnStatement() {
        if (this.getPlatformInfo().isUseDelimitedIdentifiers()) {
            return "SET quoted_identifier on" + this.getPlatformInfo().getSqlCommandDelimiter() + "\n";
        }
        return "";
    }

    private void printAlwaysSingleQuotedIdentifier(String identifier) throws IOException {
        this.print("'");
        this.print(identifier);
        this.print("'");
    }
}

