/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.builder;

import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ddlutils.PlatformInfo;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.ForeignKey;
import org.apache.ddlutils.model.Index;
import org.apache.ddlutils.model.IndexColumn;
import org.apache.ddlutils.model.Table;

public abstract class SqlBuilder {
    private static final String LINE_SEPERATOR = System.getProperty("line.separator", "\n");
    protected final Log _log = LogFactory.getLog((Class)(class$org$apache$ddlutils$builder$SqlBuilder == null ? (class$org$apache$ddlutils$builder$SqlBuilder = SqlBuilder.class$("org.apache.ddlutils.builder.SqlBuilder")) : class$org$apache$ddlutils$builder$SqlBuilder));
    private Writer _writer;
    private String _indent = "    ";
    private PlatformInfo _info;
    private String _valueLocale;
    private DateFormat _valueDateFormat;
    private DateFormat _valueTimeFormat;
    private NumberFormat _valueNumberFormat;
    static /* synthetic */ Class class$org$apache$ddlutils$builder$SqlBuilder;

    public SqlBuilder(PlatformInfo info) {
        this._info = info;
    }

    public PlatformInfo getPlatformInfo() {
        return this._info;
    }

    public Writer getWriter() {
        return this._writer;
    }

    public void setWriter(Writer writer) {
        this._writer = writer;
    }

    public String getIndent() {
        return this._indent;
    }

    public void setIndent(String indent) {
        this._indent = indent;
    }

    public String getValueLocale() {
        return this._valueLocale;
    }

    public void setValueLocale(String localeStr) {
        if (localeStr != null) {
            int sepPos = localeStr.indexOf(95);
            String language = null;
            String country = null;
            String variant = null;
            if (sepPos > 0) {
                language = localeStr.substring(0, sepPos);
                country = localeStr.substring(sepPos + 1);
                if ((sepPos = country.indexOf(95)) > 0) {
                    variant = country.substring(sepPos + 1);
                    country = country.substring(0, sepPos);
                }
            } else {
                language = localeStr;
            }
            if (language != null) {
                Locale locale = null;
                locale = variant != null ? new Locale(language, country, variant) : (country != null ? new Locale(language, country) : new Locale(language));
                this._valueLocale = localeStr;
                this._valueDateFormat = DateFormat.getDateInstance(3, locale);
                this._valueTimeFormat = DateFormat.getTimeInstance(3, locale);
                this._valueNumberFormat = NumberFormat.getNumberInstance(locale);
                return;
            }
        }
        this._valueLocale = null;
        this._valueDateFormat = null;
        this._valueTimeFormat = null;
        this._valueNumberFormat = null;
    }

    public void createTables(Database database) throws IOException {
        this.createTables(database, true, null);
    }

    public void createTables(Database database, boolean dropTables, Map parameters) throws IOException {
        if (dropTables) {
            this.dropTables(database);
        }
        for (int idx = 0; idx < database.getTableCount(); ++idx) {
            Table table = database.getTable(idx);
            this.writeTableComment(table);
            this.createTable(database, table, parameters);
        }
        this.createExternalForeignKeys(database);
    }

    public void alterDatabase(Database currentModel, Database desiredModel) throws IOException {
        this.alterDatabase(currentModel, desiredModel, false, false, null);
    }

    public void alterDatabase(Database currentModel, Database desiredModel, boolean doDrops, boolean modifyColumns, Map parameters) throws IOException {
        ArrayList<Table> newTables = new ArrayList<Table>();
        for (int tableIdx = 0; tableIdx < desiredModel.getTableCount(); ++tableIdx) {
            Table desiredTable = desiredModel.getTable(tableIdx);
            Table currentTable = currentModel.findTable(desiredTable.getName());
            if (currentTable == null) {
                if (this._log.isInfoEnabled()) {
                    this._log.info((Object)("Creating table " + desiredTable.getName()));
                }
                this.createTable(desiredModel, desiredTable, parameters);
                newTables.add(desiredTable);
                continue;
            }
            this.alterTable(currentModel, currentTable, desiredModel, desiredTable, doDrops, modifyColumns);
        }
        Iterator fkIt = newTables.iterator();
        while (fkIt.hasNext()) {
            this.createExternalForeignKeys(desiredModel, (Table)fkIt.next());
        }
        for (int idx = 0; idx < currentModel.getTableCount(); ++idx) {
            Table currentTable = currentModel.getTable(idx);
            Table desiredTable = desiredModel.findTable(currentTable.getName());
            if (desiredTable != null || currentTable.getName() == null || currentTable.getName().length() <= 0) continue;
            if (doDrops) {
                if (this._log.isInfoEnabled()) {
                    this._log.info((Object)("Dropping table " + currentTable.getName()));
                }
                this.dropTable(currentTable);
                continue;
            }
            String text = "Table " + currentTable.getName() + " can be dropped";
            if (this._log.isInfoEnabled()) {
                this._log.info((Object)text);
            }
            this.printComment(text);
        }
    }

    protected void alterTable(Database currentModel, Table currentTable, Database desiredModel, Table desiredTable, boolean doDrops, boolean modifyColumns) throws IOException {
        int indexIdx;
        int fkIdx;
        String text;
        int columnIdx;
        for (columnIdx = 0; columnIdx < desiredTable.getColumnCount(); ++columnIdx) {
            Column desiredColumn = desiredTable.getColumn(columnIdx);
            Column currentColumn = currentTable.findColumn(desiredColumn.getName());
            if (null == currentColumn) {
                if (this._log.isInfoEnabled()) {
                    this._log.info((Object)("Creating column " + desiredTable.getName() + "." + desiredColumn.getName()));
                }
                this.writeColumnAlterStmt(desiredTable, desiredColumn, true);
                continue;
            }
            if (!this.columnsDiffer(desiredColumn, currentColumn)) continue;
            if (modifyColumns) {
                if (this._log.isInfoEnabled()) {
                    this._log.info((Object)("Altering column " + desiredTable.getName() + "." + desiredColumn.getName()));
                    this._log.info((Object)("  desired = " + desiredColumn.toVerboseString()));
                    this._log.info((Object)("  current = " + currentColumn.toVerboseString()));
                }
                this.writeColumnAlterStmt(desiredTable, desiredColumn, false);
                continue;
            }
            text = "Column " + currentColumn.getName() + " in table " + currentTable.getName() + " differs from current specification";
            if (this._log.isInfoEnabled()) {
                this._log.info((Object)text);
            }
            this.printComment(text);
        }
        for (fkIdx = 0; fkIdx < desiredTable.getForeignKeyCount(); ++fkIdx) {
            ForeignKey desiredFk = desiredTable.getForeignKey(fkIdx);
            ForeignKey currentFk = currentTable.findForeignKey(desiredFk);
            if (currentFk != null) continue;
            if (this._log.isInfoEnabled()) {
                this._log.info((Object)("Creating foreign key " + desiredTable.getName() + "." + desiredFk));
            }
            this.writeExternalForeignKeyCreateStmt(desiredModel, desiredTable, desiredFk);
        }
        for (indexIdx = 0; indexIdx < desiredTable.getIndexCount(); ++indexIdx) {
            Index desiredIndex = desiredTable.getIndex(indexIdx);
            Index currentIndex = currentTable.findIndex(desiredIndex.getName());
            if (currentIndex != null) continue;
            if (this._log.isInfoEnabled()) {
                this._log.info((Object)("Creating index " + desiredTable.getName() + "." + desiredIndex.getName()));
            }
            this.writeExternalIndexCreateStmt(desiredTable, desiredIndex);
        }
        for (fkIdx = 0; fkIdx < currentTable.getForeignKeyCount(); ++fkIdx) {
            ForeignKey currentFk = currentTable.getForeignKey(fkIdx);
            ForeignKey desiredFk = desiredTable.findForeignKey(currentFk);
            if (desiredFk != null) continue;
            if (this._log.isInfoEnabled()) {
                this._log.info((Object)((doDrops ? "" : "Not ") + "Dropping foreign key " + currentTable.getName() + "." + currentFk));
            }
            if (!doDrops) continue;
            this.writeExternalForeignKeyDropStmt(currentTable, currentFk);
        }
        for (columnIdx = 0; columnIdx < currentTable.getColumnCount(); ++columnIdx) {
            Column currentColumn = currentTable.getColumn(columnIdx);
            Column desiredColumn = desiredTable.findColumn(currentColumn.getName());
            if (desiredColumn != null) continue;
            if (doDrops) {
                if (this._log.isInfoEnabled()) {
                    this._log.info((Object)("Dropping column " + currentTable.getName() + "." + currentColumn.getName()));
                }
                this.writeColumnDropStmt(currentTable, currentColumn);
                continue;
            }
            text = "Column " + currentColumn.getName() + " can be dropped from table " + currentTable.getName();
            if (this._log.isInfoEnabled()) {
                this._log.info((Object)text);
            }
            this.printComment(text);
        }
        for (indexIdx = 0; indexIdx < currentTable.getIndexCount(); ++indexIdx) {
            Index currentIndex = currentTable.getIndex(indexIdx);
            Index desiredIndex = desiredTable.findIndex(currentIndex.getName());
            if (desiredIndex != null) continue;
            boolean isPk = true;
            for (int columnIdx2 = 0; columnIdx2 < currentIndex.getColumnCount(); ++columnIdx2) {
                IndexColumn indexColumn = currentIndex.getColumn(columnIdx2);
                Column column = currentTable.findColumn(indexColumn.getName());
                if (column == null || column.isPrimaryKey()) continue;
                isPk = false;
                break;
            }
            if (isPk) continue;
            if (this._log.isInfoEnabled()) {
                this._log.info((Object)((doDrops ? "" : "Not ") + "Dropping non-primary index " + currentTable.getName() + "." + currentIndex.getName()));
            }
            if (!doDrops) continue;
            this.writeExternalIndexDropStmt(currentTable, currentIndex);
        }
    }

    public void createTable(Database database, Table table, Map parameters) throws IOException {
        this.print("CREATE TABLE ");
        this.printlnIdentifier(this.getTableName(table));
        this.println("(");
        this.writeColumns(table);
        if (this.getPlatformInfo().isPrimaryKeyEmbedded()) {
            this.writeEmbeddedPrimaryKeysStmt(table);
        }
        if (this.getPlatformInfo().isForeignKeysEmbedded()) {
            this.writeEmbeddedForeignKeysStmt(database, table);
        }
        if (this.getPlatformInfo().isIndicesEmbedded()) {
            this.writeEmbeddedIndicesStmt(table);
        }
        this.println();
        this.print(")");
        this.writeCreateTableStmtSuffix(parameters);
        this.printEndOfStatement();
        if (!this.getPlatformInfo().isPrimaryKeyEmbedded()) {
            this.writeExternalPrimaryKeysCreateStmt(table);
        }
        if (!this.getPlatformInfo().isIndicesEmbedded()) {
            this.writeExternalIndicesCreateStmt(table);
        }
    }

    protected void writeCreateTableStmtSuffix(Map parameters) throws IOException {
    }

    public void createExternalForeignKeys(Database database) throws IOException {
        for (int idx = 0; idx < database.getTableCount(); ++idx) {
            this.createExternalForeignKeys(database, database.getTable(idx));
        }
    }

    public void createExternalForeignKeys(Database database, Table table) throws IOException {
        if (!this.getPlatformInfo().isForeignKeysEmbedded()) {
            for (int idx = 0; idx < table.getForeignKeyCount(); ++idx) {
                this.writeExternalForeignKeyCreateStmt(database, table, table.getForeignKey(idx));
            }
        }
    }

    public void dropTables(Database database) throws IOException {
        Table table;
        int idx;
        for (idx = database.getTableCount() - 1; idx >= 0; --idx) {
            table = database.getTable(idx);
            if (table.getName() == null || table.getName().length() <= 0) continue;
            this.dropExternalForeignKeys(table);
        }
        for (idx = database.getTableCount() - 1; idx >= 0; --idx) {
            table = database.getTable(idx);
            if (table.getName() == null || table.getName().length() <= 0) continue;
            this.writeTableComment(table);
            this.dropTable(table);
        }
    }

    public void dropTable(Table table) throws IOException {
        this.print("DROP TABLE ");
        this.printIdentifier(this.getTableName(table));
        this.printEndOfStatement();
    }

    public void dropExternalForeignKeys(Table table) throws IOException {
        if (!this.getPlatformInfo().isForeignKeysEmbedded()) {
            for (int idx = 0; idx < table.getForeignKeyCount(); ++idx) {
                this.writeExternalForeignKeyDropStmt(table, table.getForeignKey(idx));
            }
        }
    }

    public String getInsertSql(Table table, HashMap columnValues, boolean genPlaceholders) {
        Column column;
        int idx;
        StringBuffer buffer = new StringBuffer("INSERT INTO ");
        boolean addComma = false;
        buffer.append(this.getDelimitedIdentifier(this.getTableName(table)));
        buffer.append(" (");
        for (idx = 0; idx < table.getColumnCount(); ++idx) {
            column = table.getColumn(idx);
            if (!columnValues.containsKey(column.getName())) continue;
            if (addComma) {
                buffer.append(", ");
            }
            buffer.append(this.getDelimitedIdentifier(column.getName()));
            addComma = true;
        }
        buffer.append(") VALUES (");
        if (genPlaceholders) {
            addComma = false;
            for (idx = 0; idx < columnValues.size(); ++idx) {
                if (addComma) {
                    buffer.append(", ");
                }
                buffer.append("?");
                addComma = true;
            }
        } else {
            addComma = false;
            for (idx = 0; idx < table.getColumnCount(); ++idx) {
                column = table.getColumn(idx);
                if (!columnValues.containsKey(column.getName())) continue;
                if (addComma) {
                    buffer.append(", ");
                }
                buffer.append(this.getValueAsString(column, columnValues.get(column.getName())));
                addComma = true;
            }
        }
        buffer.append(")");
        return buffer.toString();
    }

    public String getUpdateSql(Table table, HashMap columnValues, boolean genPlaceholders) {
        Column column;
        int idx;
        StringBuffer buffer = new StringBuffer("UPDATE ");
        boolean addSep = false;
        buffer.append(this.getDelimitedIdentifier(this.getTableName(table)));
        buffer.append(" SET ");
        for (idx = 0; idx < table.getColumnCount(); ++idx) {
            column = table.getColumn(idx);
            if (column.isPrimaryKey() || !columnValues.containsKey(column.getName())) continue;
            if (addSep) {
                buffer.append(", ");
            }
            buffer.append(this.getDelimitedIdentifier(column.getName()));
            buffer.append(" = ");
            if (genPlaceholders) {
                buffer.append("?");
            } else {
                buffer.append(this.getValueAsString(column, columnValues.get(column.getName())));
            }
            addSep = true;
        }
        buffer.append(" WHERE ");
        addSep = false;
        for (idx = 0; idx < table.getColumnCount(); ++idx) {
            column = table.getColumn(idx);
            if (!column.isPrimaryKey() || !columnValues.containsKey(column.getName())) continue;
            if (addSep) {
                buffer.append(" AND ");
            }
            buffer.append(this.getDelimitedIdentifier(column.getName()));
            buffer.append(" = ");
            if (genPlaceholders) {
                buffer.append("?");
            } else {
                buffer.append(this.getValueAsString(column, columnValues.get(column.getName())));
            }
            addSep = true;
        }
        return buffer.toString();
    }

    public String getDeleteSql(Table table, HashMap pkValues, boolean genPlaceholders) {
        StringBuffer buffer = new StringBuffer("DELETE FROM ");
        boolean addSep = false;
        buffer.append(this.getDelimitedIdentifier(this.getTableName(table)));
        if (pkValues != null && !pkValues.isEmpty()) {
            buffer.append(" WHERE ");
            Iterator it = pkValues.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Column column = table.findColumn((String)entry.getKey());
                if (addSep) {
                    buffer.append(" AND ");
                }
                buffer.append(this.getDelimitedIdentifier(entry.getKey().toString()));
                buffer.append(" = ");
                if (genPlaceholders) {
                    buffer.append("?");
                } else {
                    buffer.append(column == null ? entry.getValue() : this.getValueAsString(column, entry.getValue()));
                }
                addSep = true;
            }
        }
        return buffer.toString();
    }

    public String getSelectLastInsertId(Table table) {
        return null;
    }

    protected String shortenName(String name, int desiredLength) {
        int originalLength = name.length();
        if (desiredLength <= 0 || originalLength <= desiredLength) {
            return name;
        }
        int delta = originalLength - desiredLength;
        int startCut = desiredLength / 2;
        StringBuffer result = new StringBuffer();
        result.append(name.substring(0, startCut));
        if (!(startCut != 0 && name.charAt(startCut - 1) == '_' || startCut + delta + 1 != originalLength && name.charAt(startCut + delta + 1) == '_')) {
            result.append("_");
        }
        result.append(name.substring(startCut + delta + 1, originalLength));
        return result.toString();
    }

    protected String getTableName(Table table) {
        return this.shortenName(table.getName(), this.getPlatformInfo().getMaxIdentifierLength());
    }

    protected void writeTableComment(Table table) throws IOException {
        this.printComment("-----------------------------------------------------------------------");
        this.printComment(this.getTableName(table));
        this.printComment("-----------------------------------------------------------------------");
        this.println();
    }

    protected void writeTableAlterStmt(Table table) throws IOException {
        this.print("ALTER TABLE ");
        this.printlnIdentifier(this.getTableName(table));
        this.printIndent();
    }

    protected void writeColumns(Table table) throws IOException {
        for (int idx = 0; idx < table.getColumnCount(); ++idx) {
            this.printIndent();
            this.writeColumn(table, table.getColumn(idx));
            if (idx >= table.getColumnCount() - 1) continue;
            this.println(",");
        }
    }

    protected String getColumnName(Column column) throws IOException {
        return this.shortenName(column.getName(), this.getPlatformInfo().getMaxIdentifierLength());
    }

    protected void writeColumn(Table table, Column column) throws IOException {
        this.printIdentifier(this.getColumnName(column));
        this.print(" ");
        this.print(this.getSqlType(column));
        if (column.getDefaultValue() != null) {
            this.print(" DEFAULT ");
            this.print(this.getPlatformInfo().getValueQuoteToken());
            this.print(column.getDefaultValue());
            this.print(this.getPlatformInfo().getValueQuoteToken());
        }
        if (column.isRequired()) {
            this.print(" ");
            this.writeColumnNotNullableStmt();
        } else if (this.getPlatformInfo().isRequiringNullAsDefaultValue() && this.getPlatformInfo().hasNullDefault(column.getTypeCode())) {
            this.print(" ");
            this.writeColumnNullableStmt();
        }
        if (column.isAutoIncrement()) {
            this.print(" ");
            this.writeColumnAutoIncrementStmt(table, column);
        }
    }

    public void writeColumnAlterStmt(Table table, Column column, boolean isNewColumn) throws IOException {
        this.writeTableAlterStmt(table);
        this.print(isNewColumn ? "ADD " : "MODIFY ");
        this.writeColumn(table, column);
        this.printEndOfStatement();
    }

    public void writeColumnDropStmt(Table table, Column column) throws IOException {
        this.writeTableAlterStmt(table);
        this.print("DROP COLUMN ");
        this.printIdentifier(this.getColumnName(column));
        this.printEndOfStatement();
    }

    protected String getSqlType(Column column) {
        StringBuffer sqlType = new StringBuffer(this.getNativeType(column));
        if (column.getSize() != null) {
            if (this.getPlatformInfo().hasSize(column.getTypeCode())) {
                sqlType.append("(");
                sqlType.append(column.getSize());
                sqlType.append(")");
            } else if (this.getPlatformInfo().hasPrecisionAndScale(column.getTypeCode())) {
                sqlType.append("(");
                sqlType.append(column.getSize());
                sqlType.append(",");
                sqlType.append(column.getScale());
                sqlType.append(")");
            }
        }
        return sqlType.toString();
    }

    protected String getNativeType(Column column) {
        String nativeType = this.getPlatformInfo().getNativeType(column.getTypeCode());
        return nativeType == null ? column.getType() : nativeType;
    }

    protected String getValueAsString(Column column, Object value) {
        if (value == null) {
            return "NULL";
        }
        StringBuffer result = new StringBuffer();
        switch (column.getTypeCode()) {
            case 91: {
                result.append(this.getPlatformInfo().getValueQuoteToken());
                if (!(value instanceof String) && this._valueDateFormat != null) {
                    result.append(this._valueDateFormat.format(value));
                } else {
                    result.append(value.toString());
                }
                result.append(this.getPlatformInfo().getValueQuoteToken());
                break;
            }
            case 92: {
                result.append(this.getPlatformInfo().getValueQuoteToken());
                if (!(value instanceof String) && this._valueTimeFormat != null) {
                    result.append(this._valueTimeFormat.format(value));
                } else {
                    result.append(value.toString());
                }
                result.append(this.getPlatformInfo().getValueQuoteToken());
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                result.append(this.getPlatformInfo().getValueQuoteToken());
                if (!(value instanceof String) && this._valueNumberFormat != null) {
                    result.append(this._valueNumberFormat.format(value));
                } else {
                    result.append(value.toString());
                }
                result.append(this.getPlatformInfo().getValueQuoteToken());
                break;
            }
            default: {
                result.append(this.getPlatformInfo().getValueQuoteToken());
                result.append(value.toString());
                result.append(this.getPlatformInfo().getValueQuoteToken());
            }
        }
        return result.toString();
    }

    protected void writeColumnAutoIncrementStmt(Table table, Column column) throws IOException {
        this.print("IDENTITY");
    }

    protected void writeColumnNullableStmt() throws IOException {
        this.print("NULL");
    }

    protected void writeColumnNotNullableStmt() throws IOException {
        this.print("NOT NULL");
    }

    protected boolean columnsDiffer(Column columnA, Column columnB) {
        boolean sizeMatters;
        String desiredDefault = columnA.getDefaultValue();
        String currentDefault = columnB.getDefaultValue();
        boolean defaultsEqual = desiredDefault == null || desiredDefault.equals(currentDefault);
        boolean bl = sizeMatters = columnA.getSize() != null;
        return columnA.getTypeCode() != columnB.getTypeCode() || columnA.isRequired() != columnB.isRequired() || sizeMatters && !columnA.getSize().equals(columnB.getSize()) || !defaultsEqual;
    }

    protected String getForeignKeyName(ForeignKey fk) {
        StringBuffer name = new StringBuffer();
        for (int idx = 0; idx < fk.getReferenceCount(); ++idx) {
            name.append(fk.getReference(idx).getLocalColumnName());
            name.append("_");
        }
        name.append(fk.getForeignTableName());
        return name.toString();
    }

    protected String getConstraintName(String prefix, Table table, String secondPart, String suffix) {
        StringBuffer result = new StringBuffer();
        if (prefix != null) {
            result.append(prefix);
            result.append("_");
        }
        result.append(table.getName());
        result.append("_");
        result.append(secondPart);
        if (suffix != null) {
            result.append("_");
            result.append(suffix);
        }
        return this.shortenName(result.toString(), this.getPlatformInfo().getMaxIdentifierLength());
    }

    protected void writeEmbeddedPrimaryKeysStmt(Table table) throws IOException {
        Column[] primaryKeyColumns = table.getPrimaryKeyColumns();
        if (primaryKeyColumns.length > 0 && this.shouldGeneratePrimaryKeys(primaryKeyColumns)) {
            this.println(",");
            this.printIndent();
            this.writePrimaryKeyStmt(table, primaryKeyColumns);
        }
    }

    protected void writeExternalPrimaryKeysCreateStmt(Table table) throws IOException {
        Column[] primaryKeyColumns = table.getPrimaryKeyColumns();
        if (primaryKeyColumns.length > 0 && this.shouldGeneratePrimaryKeys(primaryKeyColumns)) {
            this.print("ALTER TABLE ");
            this.printlnIdentifier(this.getTableName(table));
            this.printIndent();
            this.print("ADD CONSTRAINT ");
            this.printIdentifier(this.getConstraintName(null, table, "PK", null));
            this.print(" ");
            this.writePrimaryKeyStmt(table, primaryKeyColumns);
            this.printEndOfStatement();
        }
    }

    protected boolean shouldGeneratePrimaryKeys(Column[] primaryKeyColumns) {
        for (int idx = 0; idx < primaryKeyColumns.length; ++idx) {
            if (primaryKeyColumns[idx].isAutoIncrement()) continue;
            return true;
        }
        return false;
    }

    protected void writePrimaryKeyStmt(Table table, Column[] primaryKeyColumns) throws IOException {
        this.print("PRIMARY KEY (");
        for (int idx = 0; idx < primaryKeyColumns.length; ++idx) {
            this.printIdentifier(this.getColumnName(primaryKeyColumns[idx]));
            if (idx >= primaryKeyColumns.length - 1) continue;
            this.print(", ");
        }
        this.print(")");
    }

    protected String getIndexName(Index index) throws IOException {
        return index.getName();
    }

    protected void writeExternalIndicesCreateStmt(Table table) throws IOException {
        for (int idx = 0; idx < table.getIndexCount(); ++idx) {
            this.writeExternalIndexCreateStmt(table, table.getIndex(idx));
        }
    }

    protected void writeEmbeddedIndicesStmt(Table table) throws IOException {
    }

    protected void writeExternalIndexCreateStmt(Table table, Index index) throws IOException {
        if (index.getName() == null) {
            this._log.warn((Object)("Cannot write unnamed index " + index));
        } else {
            this.print("CREATE");
            if (index.isUnique()) {
                this.print(" UNIQUE");
            }
            this.print(" INDEX ");
            this.printIdentifier(this.getIndexName(index));
            this.print(" ON ");
            this.printIdentifier(this.getTableName(table));
            this.print(" (");
            for (int idx = 0; idx < index.getColumnCount(); ++idx) {
                IndexColumn idxColumn = index.getColumn(idx);
                Column col = table.findColumn(idxColumn.getName());
                if (col == null) {
                    throw new RuntimeException("Invalid column '" + idxColumn.getName() + "' on index " + index.getName() + " for table " + table.getName());
                }
                if (idx > 0) {
                    this.print(", ");
                }
                this.printIdentifier(this.getColumnName(col));
            }
            this.print(")");
            this.printEndOfStatement();
        }
    }

    public void writeExternalIndexDropStmt(Table table, Index index) throws IOException {
        if (this.getPlatformInfo().isUseAlterTableForDrop()) {
            this.writeTableAlterStmt(table);
        }
        this.print("DROP INDEX ");
        this.printIdentifier(this.getIndexName(index));
        if (!this.getPlatformInfo().isUseAlterTableForDrop()) {
            this.print(" ON ");
            this.print(this.getTableName(table));
        }
        this.printEndOfStatement();
    }

    protected void writeEmbeddedForeignKeysStmt(Database database, Table table) throws IOException {
        for (int idx = 0; idx < table.getForeignKeyCount(); ++idx) {
            ForeignKey key = table.getForeignKey(idx);
            if (key.getForeignTableName() == null) {
                this._log.warn((Object)("Foreign key table is null for key " + key));
                continue;
            }
            this.println(",");
            this.printIndent();
            if (this.getPlatformInfo().isEmbeddedForeignKeysNamed()) {
                this.print("CONSTRAINT ");
                this.printIdentifier(this.getConstraintName(null, table, "FK", Integer.toString(idx)));
                this.print(" ");
            }
            this.print("FOREIGN KEY (");
            this.writeLocalReferences(key);
            this.print(") REFERENCES ");
            this.printIdentifier(this.getTableName(database.findTable(key.getForeignTableName())));
            this.print(" (");
            this.writeForeignReferences(key);
            this.print(")");
        }
    }

    protected void writeExternalForeignKeyCreateStmt(Database database, Table table, ForeignKey key) throws IOException {
        if (key.getForeignTableName() == null) {
            this._log.warn((Object)("Foreign key table is null for key " + key));
        } else {
            this.writeTableAlterStmt(table);
            this.print("ADD CONSTRAINT ");
            this.printIdentifier(key.getName() == null ? this.getConstraintName(null, table, "FK", this.getForeignKeyName(key)) : key.getName());
            this.print(" FOREIGN KEY (");
            this.writeLocalReferences(key);
            this.print(") REFERENCES ");
            this.printIdentifier(this.getTableName(database.findTable(key.getForeignTableName())));
            this.print(" (");
            this.writeForeignReferences(key);
            this.print(")");
            this.printEndOfStatement();
        }
    }

    protected void writeLocalReferences(ForeignKey key) throws IOException {
        for (int idx = 0; idx < key.getReferenceCount(); ++idx) {
            if (idx > 0) {
                this.print(", ");
            }
            this.printIdentifier(key.getReference(idx).getLocalColumnName());
        }
    }

    protected void writeForeignReferences(ForeignKey key) throws IOException {
        for (int idx = 0; idx < key.getReferenceCount(); ++idx) {
            if (idx > 0) {
                this.print(", ");
            }
            this.printIdentifier(key.getReference(idx).getForeignColumnName());
        }
    }

    protected void writeExternalForeignKeyDropStmt(Table table, ForeignKey foreignKey) throws IOException {
        this.writeTableAlterStmt(table);
        this.print("DROP CONSTRAINT ");
        this.printIdentifier(foreignKey.getName() == null ? this.getConstraintName(null, table, "FK", this.getForeignKeyName(foreignKey)) : foreignKey.getName());
        this.printEndOfStatement();
    }

    protected void printComment(String text) throws IOException {
        if (this.getPlatformInfo().isCommentsSupported()) {
            this.print(this.getPlatformInfo().getCommentPrefix());
            this.print(" ");
            this.print(text);
            this.print(" ");
            this.print(this.getPlatformInfo().getCommentSuffix());
            this.println();
        }
    }

    protected void printEndOfStatement() throws IOException {
        this.println(this.getPlatformInfo().getSqlCommandDelimiter());
        this.println();
    }

    protected void println() throws IOException {
        this.print(LINE_SEPERATOR);
    }

    protected void print(String text) throws IOException {
        this._writer.write(text);
    }

    protected String getDelimitedIdentifier(String identifier) {
        if (this.getPlatformInfo().isUseDelimitedIdentifiers()) {
            return this.getPlatformInfo().getDelimiterToken() + identifier + this.getPlatformInfo().getDelimiterToken();
        }
        return identifier;
    }

    protected void printIdentifier(String identifier) throws IOException {
        this.print(this.getDelimitedIdentifier(identifier));
    }

    protected void printlnIdentifier(String identifier) throws IOException {
        this.println(this.getDelimitedIdentifier(identifier));
    }

    protected void println(String text) throws IOException {
        this.print(text);
        this.println();
    }

    protected void printIndent() throws IOException {
        this.print(this.getIndent());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

