/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.builder;

import java.io.IOException;
import java.util.Map;
import org.apache.ddlutils.PlatformInfo;
import org.apache.ddlutils.builder.SqlBuilder;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.Table;

public class PostgreSqlBuilder
extends SqlBuilder {
    public PostgreSqlBuilder(PlatformInfo info) {
        super(info);
    }

    public void dropTable(Table table) throws IOException {
        this.print("DROP TABLE ");
        this.printIdentifier(this.getTableName(table));
        this.print(" CASCADE");
        this.printEndOfStatement();
        Column[] columns = table.getAutoIncrementColumn();
        for (int idx = 0; idx < columns.length; ++idx) {
            this.print("DROP SEQUENCE ");
            this.printIdentifier(this.getConstraintName(null, table, columns[idx].getName(), "seq"));
            this.printEndOfStatement();
        }
    }

    public void createTable(Database database, Table table, Map parameters) throws IOException {
        for (int idx = 0; idx < table.getColumnCount(); ++idx) {
            Column column = table.getColumn(idx);
            if (!column.isAutoIncrement()) continue;
            this.createAutoIncrementSequence(table, column);
        }
        super.createTable(database, table, parameters);
    }

    private void createAutoIncrementSequence(Table table, Column column) throws IOException {
        this.print("CREATE SEQUENCE ");
        this.printIdentifier(this.getConstraintName(null, table, column.getName(), "seq"));
        this.printEndOfStatement();
    }

    protected void writeColumnAutoIncrementStmt(Table table, Column column) throws IOException {
        this.print("UNIQUE DEFAULT nextval(");
        this.printIdentifier(this.getConstraintName(null, table, column.getName(), "seq"));
        this.print(")");
    }

    public String getSelectLastInsertId(Table table) {
        Column[] columns = table.getAutoIncrementColumn();
        if (columns.length == 0) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        result.append("SELECT ");
        for (int idx = 0; idx < columns.length; ++idx) {
            if (idx > 0) {
                result.append(", ");
            }
            result.append("CURRVAL(");
            result.append(this.getDelimitedIdentifier(this.getConstraintName(null, table, columns[idx].getName(), "seq")));
            result.append(") AS ");
            result.append(this.getDelimitedIdentifier(columns[idx].getName()));
        }
        return result.toString();
    }
}

