/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.builder;

import java.io.IOException;
import java.util.Map;
import org.apache.ddlutils.PlatformInfo;
import org.apache.ddlutils.builder.SqlBuilder;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.Table;

public class OracleBuilder
extends SqlBuilder {
    public OracleBuilder(PlatformInfo info) {
        super(info);
    }

    public void dropTable(Table table) throws IOException {
        this.print("DROP TABLE ");
        this.printIdentifier(this.getTableName(table));
        this.print(" CASCADE CONSTRAINTS");
        this.printEndOfStatement();
        Column[] columns = table.getAutoIncrementColumn();
        for (int idx = 0; idx < columns.length; ++idx) {
            this.print("DROP TRIGGER ");
            this.printIdentifier(this.getConstraintName("trg", table, columns[idx].getName(), null));
            this.printEndOfStatement();
            this.print("DROP SEQUENCE ");
            this.printIdentifier(this.getConstraintName("seq", table, columns[idx].getName(), null));
            this.printEndOfStatement();
        }
    }

    public void dropExternalForeignKeys(Table table) throws IOException {
    }

    public void createTable(Database database, Table table, Map parameters) throws IOException {
        int idx;
        Column[] columns = table.getAutoIncrementColumn();
        for (idx = 0; idx < columns.length; ++idx) {
            this.print("CREATE SEQUENCE ");
            this.printIdentifier(this.getConstraintName("seq", table, columns[idx].getName(), null));
            this.printEndOfStatement();
        }
        super.createTable(database, table, parameters);
        for (idx = 0; idx < columns.length; ++idx) {
            this.print("CREATE OR REPLACE TRIGGER ");
            this.printIdentifier(this.getConstraintName("trg", table, columns[idx].getName(), null));
            this.print(" BEFORE INSERT ON ");
            this.printIdentifier(this.getTableName(table));
            this.println(" FOR EACH ROW");
            this.println("BEGIN");
            this.print("SELECT ");
            this.printIdentifier(this.getConstraintName("seq", table, columns[idx].getName(), null));
            this.print(".nextval INTO :new.");
            this.printIdentifier(this.getColumnName(columns[idx]));
            this.println(" FROM dual;");
            this.print("END");
            this.printEndOfStatement();
        }
    }

    protected String getSqlType(Column column) {
        switch (column.getTypeCode()) {
            case -2: 
            case 12: {
                StringBuffer sqlType = new StringBuffer();
                sqlType.append(this.getNativeType(column));
                sqlType.append("(");
                if (column.getSize() == null) {
                    sqlType.append("254");
                } else {
                    sqlType.append(column.getSize());
                }
                sqlType.append(")");
                return sqlType.toString();
            }
        }
        return super.getSqlType(column);
    }

    protected void writeColumnAutoIncrementStmt(Table table, Column column) throws IOException {
    }
}

