/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.builder;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.apache.ddlutils.PlatformInfo;
import org.apache.ddlutils.builder.SqlBuilder;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Table;

public class MySqlBuilder
extends SqlBuilder {
    public MySqlBuilder(PlatformInfo info) {
        super(info);
    }

    public void dropTable(Table table) throws IOException {
        this.print("DROP TABLE IF EXISTS ");
        this.printIdentifier(this.getTableName(table));
        this.printEndOfStatement();
    }

    protected String getSqlType(Column column) {
        switch (column.getTypeCode()) {
            case -3: 
            case -2: {
                StringBuffer sqlType = new StringBuffer();
                sqlType.append(this.getNativeType(column));
                sqlType.append("(");
                if (column.getSize() == null) {
                    sqlType.append("254");
                } else {
                    sqlType.append(column.getSize());
                }
                sqlType.append(") BINARY");
                return sqlType.toString();
            }
        }
        return super.getSqlType(column);
    }

    protected void writeColumnAutoIncrementStmt(Table table, Column column) throws IOException {
        this.print("AUTO_INCREMENT");
    }

    protected boolean shouldGeneratePrimaryKeys(Column[] primaryKeyColumns) {
        return true;
    }

    public String getSelectLastInsertId(Table table) {
        return "SELECT LAST_INSERT_ID()";
    }

    protected void writeCreateTableStmtSuffix(Map parameters) throws IOException {
        if (parameters != null && !parameters.isEmpty()) {
            Iterator it = parameters.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String key = entry.getKey().toString();
                if (!"engine".equalsIgnoreCase(key) && !"type".equalsIgnoreCase(key) || entry.getValue() == null) continue;
                this.print(" " + entry.getKey().toString().toUpperCase() + "=" + entry.getValue().toString());
            }
        }
    }
}

