/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.builder;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.ddlutils.PlatformInfo;
import org.apache.ddlutils.builder.SqlBuilder;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.ForeignKey;
import org.apache.ddlutils.model.Index;
import org.apache.ddlutils.model.Table;

public class MSSqlBuilder
extends SqlBuilder {
    public MSSqlBuilder(PlatformInfo info) {
        super(info);
    }

    public void createTable(Database database, Table table, Map parameters) throws IOException {
        this.writeQuotationOnStatement();
        super.createTable(database, table, parameters);
    }

    protected void alterTable(Database currentModel, Table currentTable, Database desiredModel, Table desiredTable, boolean doDrops, boolean modifyColumns) throws IOException {
        this.writeQuotationOnStatement();
        super.alterTable(currentModel, currentTable, desiredModel, desiredTable, doDrops, modifyColumns);
    }

    public void dropTable(Table table) throws IOException {
        String tableName = this.getTableName(table);
        this.writeQuotationOnStatement();
        this.print("IF EXISTS (SELECT 1 FROM sysobjects WHERE type = 'U' AND name = ");
        this.printAlwaysSingleQuotedIdentifier(tableName);
        this.println(")");
        this.println("BEGIN");
        this.println("     DECLARE @reftable nvarchar(60), @constraintname nvarchar(60)");
        this.println("     DECLARE refcursor CURSOR FOR");
        this.println("     select reftables.name tablename, cons.name constraintname");
        this.println("      from sysobjects tables,");
        this.println("           sysobjects reftables,");
        this.println("           sysobjects cons,");
        this.println("           sysreferences ref");
        this.println("       where tables.id = ref.rkeyid");
        this.println("         and cons.id = ref.constid");
        this.println("         and reftables.id = ref.fkeyid");
        this.print("         and tables.name = ");
        this.printAlwaysSingleQuotedIdentifier(tableName);
        this.println("     OPEN refcursor");
        this.println("     FETCH NEXT from refcursor into @reftable, @constraintname");
        this.println("     while @@FETCH_STATUS = 0");
        this.println("     BEGIN");
        this.println("       exec ('alter table '+@reftable+' drop constraint '+@constraintname)");
        this.println("       FETCH NEXT from refcursor into @reftable, @constraintname");
        this.println("     END");
        this.println("     CLOSE refcursor");
        this.println("     DEALLOCATE refcursor");
        this.print("     DROP TABLE ");
        this.printlnIdentifier(tableName);
        this.print("END");
        this.printEndOfStatement();
    }

    public void dropExternalForeignKeys(Table table) throws IOException {
        this.writeQuotationOnStatement();
        super.dropExternalForeignKeys(table);
    }

    protected void writeColumnAutoIncrementStmt(Table table, Column column) throws IOException {
        this.print("IDENTITY (1,1) ");
    }

    protected boolean shouldGeneratePrimaryKeys(Column[] primaryKeyColumns) {
        return primaryKeyColumns.length > 0;
    }

    public void writeExternalIndexDropStmt(Table table, Index index) throws IOException {
        this.print("DROP INDEX ");
        this.printIdentifier(this.getTableName(table));
        this.print(".");
        this.printIdentifier(this.getIndexName(index));
        this.printEndOfStatement();
    }

    public void writeColumnAlterStmt(Table table, Column column, boolean isNewColumn) throws IOException {
        this.writeTableAlterStmt(table);
        this.print(isNewColumn ? "ADD " : "ALTER COLUMN ");
        this.writeColumn(table, column);
        this.printEndOfStatement();
    }

    protected void writeExternalForeignKeyDropStmt(Table table, ForeignKey foreignKey) throws IOException {
        String constraintName = foreignKey.getName() == null ? this.getConstraintName(null, table, "FK", this.getForeignKeyName(foreignKey)) : foreignKey.getName();
        this.print("IF EXISTS (SELECT 1 FROM sysobjects WHERE type = 'RI' AND name = ");
        this.printAlwaysSingleQuotedIdentifier(constraintName);
        this.println(")");
        this.printIndent();
        this.print("ALTER TABLE ");
        this.printIdentifier(this.getTableName(table));
        this.print(" DROP CONSTRAINT ");
        this.printIdentifier(constraintName);
        this.printEndOfStatement();
    }

    private void writeQuotationOnStatement() throws IOException {
        if (this.getPlatformInfo().isUseDelimitedIdentifiers()) {
            this.print("SET quoted_identifier on");
            this.printEndOfStatement();
        }
    }

    public String getDeleteSql(Table table, HashMap pkValues, boolean genPlaceholders) {
        return this.getQuotationOnStatement() + super.getDeleteSql(table, pkValues, genPlaceholders);
    }

    public String getInsertSql(Table table, HashMap columnValues, boolean genPlaceholders) {
        return this.getQuotationOnStatement() + super.getInsertSql(table, columnValues, genPlaceholders);
    }

    public String getUpdateSql(Table table, HashMap columnValues, boolean genPlaceholders) {
        return this.getQuotationOnStatement() + super.getUpdateSql(table, columnValues, genPlaceholders);
    }

    private String getQuotationOnStatement() {
        if (this.getPlatformInfo().isUseDelimitedIdentifiers()) {
            return "SET quoted_identifier on" + this.getPlatformInfo().getSqlCommandDelimiter() + "\n";
        }
        return "";
    }

    private void printAlwaysSingleQuotedIdentifier(String identifier) throws IOException {
        this.print("'");
        this.print(identifier);
        this.print("'");
    }
}

