/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.builder;

import java.io.IOException;
import java.util.Map;
import org.apache.ddlutils.PlatformInfo;
import org.apache.ddlutils.builder.SqlBuilder;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.ForeignKey;
import org.apache.ddlutils.model.Table;

public class InterbaseBuilder
extends SqlBuilder {
    public InterbaseBuilder(PlatformInfo info) {
        super(info);
    }

    protected void writeExternalForeignKeyCreateStmt(Database database, Table table, ForeignKey key) throws IOException {
        super.writeExternalForeignKeyCreateStmt(database, table, key);
        if (key.getForeignTableName() != null) {
            this.print("COMMIT");
            this.printEndOfStatement();
        }
    }

    protected void writeExternalForeignKeyDropStmt(Table table, ForeignKey foreignKey) throws IOException {
        super.writeExternalForeignKeyDropStmt(table, foreignKey);
        this.print("COMMIT");
        this.printEndOfStatement();
    }

    public void createTable(Database database, Table table, Map parameters) throws IOException {
        super.createTable(database, table, parameters);
        this.print("COMMIT");
        this.printEndOfStatement();
        Column[] columns = table.getAutoIncrementColumn();
        for (int idx = 0; idx < columns.length; ++idx) {
            this.print("CREATE GENERATOR ");
            this.printIdentifier(this.getConstraintName("gen", table, columns[idx].getName(), null));
            this.printEndOfStatement();
            this.print("COMMIT");
            this.printEndOfStatement();
            this.print("SET TERM !!");
            this.printEndOfStatement();
            this.print("CREATE TRIGGER ");
            this.printIdentifier(this.getConstraintName("trg", table, columns[idx].getName(), null));
            this.print(" FOR ");
            this.printlnIdentifier(this.getTableName(table));
            this.println("ACTIVE BEFORE INSERT POSITION 0 AS");
            this.println("BEGIN");
            this.print("IF (NEW.");
            this.printIdentifier(this.getColumnName(columns[idx]));
            this.println(" IS NULL) THEN");
            this.print("NEW.");
            this.printIdentifier(this.getColumnName(columns[idx]));
            this.print(" = GEN_ID(");
            this.printIdentifier(this.getConstraintName("gen", table, columns[idx].getName(), null));
            this.println(", 1);");
            this.println("END !!");
            this.print("SET TERM ");
            this.print(this.getPlatformInfo().getSqlCommandDelimiter());
            this.println(" !!");
            this.print("COMMIT");
            this.printEndOfStatement();
        }
    }

    protected String getSqlType(Column column) {
        switch (column.getTypeCode()) {
            case -3: 
            case -2: {
                return super.getSqlType(column) + " CHARACTER SET OCTETS";
            }
        }
        return super.getSqlType(column);
    }

    public void dropTable(Table table) throws IOException {
        Column[] columns = table.getAutoIncrementColumn();
        for (int idx = 0; idx < columns.length; ++idx) {
            this.print("DELETE FROM RDB$GENERATOR WHERE RDB$GENERATOR_NAME = ");
            this.printIdentifier(this.getConstraintName("gen", table, columns[idx].getName(), null));
            this.printEndOfStatement();
            this.print("COMMIT");
            this.printEndOfStatement();
        }
        super.dropTable(table);
        this.print("COMMIT");
        this.printEndOfStatement();
    }

    protected void writeColumnAutoIncrementStmt(Table table, Column column) throws IOException {
    }
}

