/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils;

import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.ddlutils.DdlUtilsException;
import org.apache.ddlutils.Platform;
import org.apache.ddlutils.PlatformUtils;

public class PlatformFactory {
    private static Map _platforms = null;
    static /* synthetic */ Class class$org$apache$ddlutils$platform$AxionPlatform;
    static /* synthetic */ Class class$org$apache$ddlutils$platform$CloudscapePlatform;
    static /* synthetic */ Class class$org$apache$ddlutils$platform$Db2Platform;
    static /* synthetic */ Class class$org$apache$ddlutils$platform$DerbyPlatform;
    static /* synthetic */ Class class$org$apache$ddlutils$platform$FirebirdPlatform;
    static /* synthetic */ Class class$org$apache$ddlutils$platform$HsqlDbPlatform;
    static /* synthetic */ Class class$org$apache$ddlutils$platform$InterbasePlatform;
    static /* synthetic */ Class class$org$apache$ddlutils$platform$MaxDbPlatform;
    static /* synthetic */ Class class$org$apache$ddlutils$platform$MckoiPlatform;
    static /* synthetic */ Class class$org$apache$ddlutils$platform$MSSqlPlatform;
    static /* synthetic */ Class class$org$apache$ddlutils$platform$MySqlPlatform;
    static /* synthetic */ Class class$org$apache$ddlutils$platform$Oracle8Platform;
    static /* synthetic */ Class class$org$apache$ddlutils$platform$Oracle9Platform;
    static /* synthetic */ Class class$org$apache$ddlutils$platform$PostgreSqlPlatform;
    static /* synthetic */ Class class$org$apache$ddlutils$platform$SapDbPlatform;
    static /* synthetic */ Class class$org$apache$ddlutils$platform$SybasePlatform;
    static /* synthetic */ Class class$org$apache$ddlutils$Platform;

    private static synchronized Map getPlatforms() {
        if (_platforms == null) {
            _platforms = new HashMap();
            PlatformFactory.registerPlatforms();
        }
        return _platforms;
    }

    public static synchronized Platform createNewPlatformInstance(String databaseName) throws DdlUtilsException {
        Class platformClass = (Class)PlatformFactory.getPlatforms().get(databaseName.toLowerCase());
        try {
            return platformClass != null ? (Platform)platformClass.newInstance() : null;
        }
        catch (Exception ex) {
            throw new DdlUtilsException("Could not create platform for database " + databaseName, ex);
        }
    }

    public static synchronized Platform createNewPlatformInstance(String jdbcDriver, String jdbcConnectionUrl) throws DdlUtilsException {
        return PlatformFactory.createNewPlatformInstance(new PlatformUtils().determineDatabaseType(jdbcDriver, jdbcConnectionUrl));
    }

    public static synchronized Platform createNewPlatformInstance(DataSource dataSource) throws DdlUtilsException {
        Platform platform = PlatformFactory.createNewPlatformInstance(new PlatformUtils().determineDatabaseType(dataSource));
        platform.setDataSource(dataSource);
        return platform;
    }

    public static synchronized String[] getSupportedPlatforms() {
        return PlatformFactory.getPlatforms().keySet().toArray(new String[0]);
    }

    public static boolean isPlatformSupported(String platformName) {
        return PlatformFactory.getPlatforms().containsKey(platformName.toLowerCase());
    }

    public static synchronized void registerPlatform(String platformName, Class platformClass) {
        PlatformFactory.addPlatform(PlatformFactory.getPlatforms(), platformName, platformClass);
    }

    private static void registerPlatforms() {
        PlatformFactory.addPlatform(_platforms, "Axion", class$org$apache$ddlutils$platform$AxionPlatform == null ? (class$org$apache$ddlutils$platform$AxionPlatform = PlatformFactory.class$("org.apache.ddlutils.platform.AxionPlatform")) : class$org$apache$ddlutils$platform$AxionPlatform);
        PlatformFactory.addPlatform(_platforms, "Cloudscape", class$org$apache$ddlutils$platform$CloudscapePlatform == null ? (class$org$apache$ddlutils$platform$CloudscapePlatform = PlatformFactory.class$("org.apache.ddlutils.platform.CloudscapePlatform")) : class$org$apache$ddlutils$platform$CloudscapePlatform);
        PlatformFactory.addPlatform(_platforms, "DB2", class$org$apache$ddlutils$platform$Db2Platform == null ? (class$org$apache$ddlutils$platform$Db2Platform = PlatformFactory.class$("org.apache.ddlutils.platform.Db2Platform")) : class$org$apache$ddlutils$platform$Db2Platform);
        PlatformFactory.addPlatform(_platforms, "Derby", class$org$apache$ddlutils$platform$DerbyPlatform == null ? (class$org$apache$ddlutils$platform$DerbyPlatform = PlatformFactory.class$("org.apache.ddlutils.platform.DerbyPlatform")) : class$org$apache$ddlutils$platform$DerbyPlatform);
        PlatformFactory.addPlatform(_platforms, "Firebird", class$org$apache$ddlutils$platform$FirebirdPlatform == null ? (class$org$apache$ddlutils$platform$FirebirdPlatform = PlatformFactory.class$("org.apache.ddlutils.platform.FirebirdPlatform")) : class$org$apache$ddlutils$platform$FirebirdPlatform);
        PlatformFactory.addPlatform(_platforms, "HsqlDb", class$org$apache$ddlutils$platform$HsqlDbPlatform == null ? (class$org$apache$ddlutils$platform$HsqlDbPlatform = PlatformFactory.class$("org.apache.ddlutils.platform.HsqlDbPlatform")) : class$org$apache$ddlutils$platform$HsqlDbPlatform);
        PlatformFactory.addPlatform(_platforms, "Interbase", class$org$apache$ddlutils$platform$InterbasePlatform == null ? (class$org$apache$ddlutils$platform$InterbasePlatform = PlatformFactory.class$("org.apache.ddlutils.platform.InterbasePlatform")) : class$org$apache$ddlutils$platform$InterbasePlatform);
        PlatformFactory.addPlatform(_platforms, "MaxDB", class$org$apache$ddlutils$platform$MaxDbPlatform == null ? (class$org$apache$ddlutils$platform$MaxDbPlatform = PlatformFactory.class$("org.apache.ddlutils.platform.MaxDbPlatform")) : class$org$apache$ddlutils$platform$MaxDbPlatform);
        PlatformFactory.addPlatform(_platforms, "McKoi", class$org$apache$ddlutils$platform$MckoiPlatform == null ? (class$org$apache$ddlutils$platform$MckoiPlatform = PlatformFactory.class$("org.apache.ddlutils.platform.MckoiPlatform")) : class$org$apache$ddlutils$platform$MckoiPlatform);
        PlatformFactory.addPlatform(_platforms, "MsSql", class$org$apache$ddlutils$platform$MSSqlPlatform == null ? (class$org$apache$ddlutils$platform$MSSqlPlatform = PlatformFactory.class$("org.apache.ddlutils.platform.MSSqlPlatform")) : class$org$apache$ddlutils$platform$MSSqlPlatform);
        PlatformFactory.addPlatform(_platforms, "MySQL", class$org$apache$ddlutils$platform$MySqlPlatform == null ? (class$org$apache$ddlutils$platform$MySqlPlatform = PlatformFactory.class$("org.apache.ddlutils.platform.MySqlPlatform")) : class$org$apache$ddlutils$platform$MySqlPlatform);
        PlatformFactory.addPlatform(_platforms, "Oracle", class$org$apache$ddlutils$platform$Oracle8Platform == null ? (class$org$apache$ddlutils$platform$Oracle8Platform = PlatformFactory.class$("org.apache.ddlutils.platform.Oracle8Platform")) : class$org$apache$ddlutils$platform$Oracle8Platform);
        PlatformFactory.addPlatform(_platforms, "Oracle9", class$org$apache$ddlutils$platform$Oracle9Platform == null ? (class$org$apache$ddlutils$platform$Oracle9Platform = PlatformFactory.class$("org.apache.ddlutils.platform.Oracle9Platform")) : class$org$apache$ddlutils$platform$Oracle9Platform);
        PlatformFactory.addPlatform(_platforms, "PostgreSql", class$org$apache$ddlutils$platform$PostgreSqlPlatform == null ? (class$org$apache$ddlutils$platform$PostgreSqlPlatform = PlatformFactory.class$("org.apache.ddlutils.platform.PostgreSqlPlatform")) : class$org$apache$ddlutils$platform$PostgreSqlPlatform);
        PlatformFactory.addPlatform(_platforms, "SapDB", class$org$apache$ddlutils$platform$SapDbPlatform == null ? (class$org$apache$ddlutils$platform$SapDbPlatform = PlatformFactory.class$("org.apache.ddlutils.platform.SapDbPlatform")) : class$org$apache$ddlutils$platform$SapDbPlatform);
        PlatformFactory.addPlatform(_platforms, "Sybase", class$org$apache$ddlutils$platform$SybasePlatform == null ? (class$org$apache$ddlutils$platform$SybasePlatform = PlatformFactory.class$("org.apache.ddlutils.platform.SybasePlatform")) : class$org$apache$ddlutils$platform$SybasePlatform);
    }

    private static synchronized void addPlatform(Map platformMap, String platformName, Class platformClass) {
        if (!(class$org$apache$ddlutils$Platform == null ? (class$org$apache$ddlutils$Platform = PlatformFactory.class$("org.apache.ddlutils.Platform")) : class$org$apache$ddlutils$Platform).isAssignableFrom(platformClass)) {
            throw new IllegalArgumentException("Cannot register class " + platformClass.getName() + " because it does not implement the " + (class$org$apache$ddlutils$Platform == null ? (class$org$apache$ddlutils$Platform = PlatformFactory.class$("org.apache.ddlutils.Platform")) : class$org$apache$ddlutils$Platform).getName() + " interface");
        }
        platformMap.put(platformName.toLowerCase(), platformClass);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

