package com.imcode.util;

import junit.framework.*;
import com.imcode.util.LineReader;

import java.io.StringReader;
import java.io.IOException;

public class LineReaderTest extends TestCase {

    public void testReadLine() throws IOException {
        LineReader lineReader = createReader("foo\nbar\r\nbaz\r");
        assertEquals(0, lineReader.getLinesRead());
        assertEquals("foo\n", lineReader.readLine()) ;
        assertEquals(1, lineReader.getLinesRead());
        assertEquals("bar\r\n", lineReader.readLine()) ;
        assertEquals(2, lineReader.getLinesRead());
        assertEquals("baz\r", lineReader.readLine());
        assertEquals(3, lineReader.getLinesRead());
        assertNull(lineReader.readLine()) ;
        assertEquals(3, lineReader.getLinesRead());
        assertNull(lineReader.readLine()) ;
        assertEquals(3, lineReader.getLinesRead());
    }

    private LineReader createReader(String string) {
        return new LineReader(new StringReader(string));
    }

    public void testEmpty() throws IOException {
        LineReader lineReader = createReader("") ;
        assertNull(lineReader.readLine()) ;
        assertNull(lineReader.readLine()) ;
    }
    
    public void testMixedNewlines() throws IOException {
        LineReader lineReader = createReader("\n\r\r\n\r\r\n\n\r\n");
        assertEquals("\n", lineReader.readLine()) ;
        assertEquals("\r", lineReader.readLine()) ;
        assertEquals("\r\n", lineReader.readLine()) ;
        assertEquals("\r", lineReader.readLine()) ;
        assertEquals("\r\n", lineReader.readLine()) ;
        assertEquals("\n", lineReader.readLine()) ;
        assertEquals("\r\n", lineReader.readLine()) ;
    }
}