package com.imcode.util;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;

/**
 * A reader that doesn't eat newlines like BuffereReader does.
 * 
 * @author kreiger
 */
public class LineReader {

    private final PushbackReader reader ;
    private final int expectedMaximumLineLength;

    private int linesRead ;

    public LineReader(Reader reader) {
        this(reader, 96) ;
    }

    public LineReader(Reader reader, int expectedMaximumLineLength) {
        this.reader = new PushbackReader(reader) ;
        this.expectedMaximumLineLength = expectedMaximumLineLength;
    }

    public int getLinesRead() {
        return linesRead;
    }

    public String readLine() throws IOException {
        StringBuffer line = new StringBuffer(expectedMaximumLineLength);
        for ( int c = reader.read(); -1 != c; c = reader.read() ) {
            line.append( (char)c );
            if ( '\n' == c ) {
                break;
            } else if ( '\r' == c ) {
                c = reader.read() ;
                if ( '\n' == c ) {
                    line.append( (char)c ) ;
                } else if ( -1 != c ) {
                    reader.unread(c);
                }
                break ;
            }
        }
        if ( line.length() == 0 ) {
            return null;
        }
        linesRead++ ;
        return line.toString();
    }

}
