package com.imcode.util;

import junit.framework.*;
import com.imcode.util.MultipartHttpServletRequest;

public class MultipartHttpServletRequestTest extends TestCase {

    public void testGetCharsetFromContentType() throws Exception {
        assertEquals(MultipartHttpServletRequest.CHARSET_ISO_8859_1, MultipartHttpServletRequest.getCharsetFromContentType(null)) ;
        assertEquals(MultipartHttpServletRequest.CHARSET_ISO_8859_1, MultipartHttpServletRequest.getCharsetFromContentType("text/plain")) ;
        assertEquals("iso-8859-1", MultipartHttpServletRequest.getCharsetFromContentType("text/plain; charset=\"iso-8859-1\"")) ;
        assertEquals("iso-8859-1", MultipartHttpServletRequest.getCharsetFromContentType("text/plain; charset=iso-8859-1")) ;
        assertEquals("iso-8859-1", MultipartHttpServletRequest.getCharsetFromContentType("text/plain; charset=\"iso-8859-1\"; foo=\"bar\"")) ;
        assertEquals("iso-8859-1", MultipartHttpServletRequest.getCharsetFromContentType("text/plain; charset=iso-8859-1; foo=bar")) ;
    }

    public void testGetStringFromBytesWithContentType() throws Exception {
        assertEquals("A", MultipartHttpServletRequest.getStringFromBytesWithContentType(new byte[] {65}, null)) ;
        assertEquals("A", MultipartHttpServletRequest.getStringFromBytesWithContentType(new byte[] {65}, "text/plain")) ;
        assertEquals("A", MultipartHttpServletRequest.getStringFromBytesWithContentType(new byte[] {65}, "text/plain; charset=\"foo\"")) ;
        assertEquals("\u00f6", MultipartHttpServletRequest.getStringFromBytesWithContentType(new byte[] {(byte)0xf6}, "text/plain")) ;
        assertEquals("\u00f6", MultipartHttpServletRequest.getStringFromBytesWithContentType(new byte[] {(byte)0xc3, (byte)0xb6}, "text/plain; charset=\"utf-8\"")) ;
    }
}
