package com.imcode.util;

import junit.framework.*;
import org.apache.commons.lang.StringEscapeUtils;


public class KeywordsParserTest extends TestCase
{
    KeywordsParser keywordsParser;

    public KeywordsParserTest(String name)
    {
        super(name);
    }

    public void setUp() throws Exception
    {
        this.keywordsParser = new KeywordsParser();
        super.setUp();
    }

    public void tearDown() throws Exception
    {
        super.tearDown();
    }


    public void testParseKeywords() {

        String keywordString = "foo, bar,\"foo bar\"  glob";
        String[] keywords = keywordsParser.parseKeywords(keywordString);
        assertEquals("foo", keywords[0]);
        assertEquals("bar", keywords[1]);
        assertEquals("foo bar", keywords[2]);
        assertEquals("glob", keywords[3]);

    }

    public void testGetFormatedKeywordsString() {

        String keywordString = "glob, \"foo bar\"  foo , bar";
        String formatedKeywordsString = StringEscapeUtils.escapeHtml(keywordsParser.formatKeywords(keywordsParser.parseKeywords(keywordString)));
        assertEquals("glob, &quot;foo bar&quot;, foo, bar", formatedKeywordsString);
    }
}
