/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.db.commands;

import com.imcode.db.DatabaseCommand;
import com.imcode.db.DatabaseConnection;
import com.imcode.db.DatabaseException;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.lang.UnhandledException;

public abstract class TransactionDatabaseCommand
implements DatabaseCommand {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object executeOn(DatabaseConnection dc) throws DatabaseException {
        try {
            Connection connection = dc.getConnection();
            try {
                connection.setAutoCommit(false);
                Object result = this.executeInTransaction(dc);
                connection.commit();
                Object object = result;
                return object;
            }
            catch (Throwable t) {
                connection.rollback();
                if (!(t instanceof RuntimeException)) throw new UnhandledException(t);
                throw (RuntimeException)t;
            }
            finally {
                connection.setAutoCommit(true);
            }
        }
        catch (SQLException e) {
            throw DatabaseException.fromSQLException(null, e);
        }
    }

    public abstract Object executeInTransaction(DatabaseConnection var1) throws DatabaseException;
}

