/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.db.commands;

import com.imcode.db.DatabaseConnection;
import com.imcode.db.DatabaseException;
import com.imcode.db.commands.ColumnValuesDatabaseCommand;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang.StringUtils;

public class DeleteWhereColumnsEqualDatabaseCommand
extends ColumnValuesDatabaseCommand {
    public DeleteWhereColumnsEqualDatabaseCommand(String table, String column, Object columnValue) {
        this(table, new Object[][]{{column, columnValue}});
    }

    public DeleteWhereColumnsEqualDatabaseCommand(String table, Object[][] columnNamesAndValues) {
        super(table, columnNamesAndValues);
    }

    public Object executeOn(DatabaseConnection connection) throws DatabaseException {
        Collection whereClauses = CollectionUtils.collect(Arrays.asList(this.columnNames), (Transformer)new ColumnNameToWhereClauseTransformer());
        String joinedWhereClauses = StringUtils.join(whereClauses.iterator(), (String)" AND ");
        return new Integer(connection.executeUpdate("DELETE FROM " + this.tableName + " WHERE " + joinedWhereClauses, this.columnValues));
    }

    private static class ColumnNameToWhereClauseTransformer
    implements Transformer {
        private ColumnNameToWhereClauseTransformer() {
        }

        public Object transform(Object object) {
            return object + " = ?";
        }
    }
}

