/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.db.benchmark;

import com.imcode.db.benchmark.BenchmarkDatabase;
import com.imcode.db.jdbc.CountingResultSet;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.lang.time.StopWatch;

public class BenchmarkResultSet
extends CountingResultSet {
    private BenchmarkDatabase benchmarkDatabase;
    private final String sql;
    private StopWatch stopWatch = new StopWatch();

    public BenchmarkResultSet(BenchmarkDatabase benchmarkDatabase, String sql, ResultSet resultSet) {
        super(resultSet);
        this.benchmarkDatabase = benchmarkDatabase;
        this.sql = sql;
    }

    public boolean next() throws SQLException {
        boolean b;
        if (0 == this.getRowCount()) {
            this.stopWatch.start();
        }
        if (!(b = super.next())) {
            this.stopWatch.stop();
            long time = this.stopWatch.getTime();
            this.benchmarkDatabase.getAverages(this.sql).getRowAverage().add(time, this.getRowCount());
        }
        return b;
    }
}

