/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.db;

import com.imcode.db.Database;
import com.imcode.db.DatabaseCommand;
import com.imcode.db.DatabaseException;
import com.imcode.db.JdbcDatabaseConnection;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;

public class DataSourceDatabase
implements Database {
    private DataSource dataSource;

    public DataSourceDatabase(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(DatabaseCommand databaseCommand) throws DatabaseException {
        Object object;
        Connection connection = this.dataSource.getConnection();
        try {
            JdbcDatabaseConnection defaultDatabaseConnection = new JdbcDatabaseConnection(connection);
            object = databaseCommand.executeOn(defaultDatabaseConnection);
        }
        catch (Throwable throwable) {
            try {
                connection.close();
                throw throwable;
            }
            catch (SQLException e) {
                throw DatabaseException.fromSQLException(e);
            }
        }
        connection.close();
        return object;
    }

    public Object executeCommand(DatabaseCommand databaseCommand) throws DatabaseException {
        return this.execute(databaseCommand);
    }
}

