package com.imcode.db.commands;

import com.imcode.db.DatabaseCommand;
import com.imcode.db.DatabaseConnection;
import com.imcode.db.DatabaseException;
import org.apache.commons.lang.UnhandledException;

import java.sql.Connection;
import java.sql.SQLException;

/**
    An abstract DatabaseCommand that can be overridden to run something in an transaction. 
**/
public abstract class TransactionDatabaseCommand implements DatabaseCommand {

    public Object executeOn( DatabaseConnection dc ) throws DatabaseException {
        try {
            Connection connection = dc.getConnection() ;
            try {
                connection.setAutoCommit( false );
                Object result = executeInTransaction( dc );
                connection.commit();
                return result;
            } catch ( Throwable t ) {
                connection.rollback();
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t ;
                } else {
                    throw new UnhandledException( t ) ;
                }
            } finally {
                connection.setAutoCommit( true );
            }
        } catch ( SQLException e ) {
            throw DatabaseException.fromSQLException( null, e );
        }
    }

    public abstract Object executeInTransaction( DatabaseConnection connection ) throws DatabaseException;

}
