package com.imcode.db.commands;

import com.imcode.db.DatabaseCommand;
import com.imcode.db.DatabaseConnection;
import com.imcode.db.DatabaseException;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.lang.ArrayUtils;

public class SqlQueryCommand implements DatabaseCommand {

    private final String sql;
    private final Object[] parameters;
    private final ResultSetHandler resultSetHandler;

    public SqlQueryCommand( String sql, Object[] parameters, ResultSetHandler resultSetHandler ) {
        this.sql = sql;
        this.parameters = parameters;
        this.resultSetHandler = resultSetHandler;
    }

    public Object executeOn( DatabaseConnection connection ) throws DatabaseException {
        return connection.executeQuery( sql, parameters, resultSetHandler );
    }

    public String toString() {
        return "query "+sql+" "+ ArrayUtils.toString( parameters ) ;
    }

}
