package com.imcode.db.benchmark;

import com.imcode.db.jdbc.ConnectionWrapper;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

class BenchmarkConnection extends ConnectionWrapper {

    private BenchmarkDatabase benchmarkDatabase;

    BenchmarkConnection(BenchmarkDatabase benchmarkDatabase, Connection connection) {
        super(connection);
        this.benchmarkDatabase = benchmarkDatabase;
    }

    public PreparedStatement prepareStatement(final String sql) throws SQLException {
        return new BenchmarkPreparedStatement(benchmarkDatabase, connection.prepareStatement(sql), sql);
    }
}
