package com.imcode.db;

import com.imcode.db.Database;
import com.imcode.db.DatabaseConnection;
import com.imcode.db.DatabaseCommand;
import com.imcode.db.DatabaseException;

public class SingleConnectionDatabase implements Database {

    private final DatabaseConnection connection;

    public SingleConnectionDatabase(DatabaseConnection connection) {
        this.connection = connection;
    }

    public Object execute(DatabaseCommand databaseCommand) throws DatabaseException {
        return databaseCommand.executeOn(connection) ;
    }

    public Object executeCommand(DatabaseCommand databaseCommand) throws DatabaseException {
        return execute(databaseCommand) ;
    }
}
