package com.imcode.db;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.sql.ResultSet;

public class JdbcUtils {

    private JdbcUtils() {
    }

    public static Number executeUpdateAndGetGeneratedKey(Connection connection, String sql, Object[] parameters) throws SQLException {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(sql, Statement.RETURN_GENERATED_KEYS);
            setPreparedStatementParameters(preparedStatement, parameters);
            preparedStatement.executeUpdate();
            ResultSet generatedKeysResultSet = preparedStatement.getGeneratedKeys();
            try {
                Number result = null;
                if (generatedKeysResultSet.next()) {
                    result = (Number) generatedKeysResultSet.getObject(1);
                }
                return result;
            } finally {
                generatedKeysResultSet.close();
            }
        } finally {
            if (null != preparedStatement) {
                preparedStatement.close();
            }
        }
    }

    public static void setPreparedStatementParameters(PreparedStatement preparedStatement, Object[] parameters) throws SQLException {
        for (int i = 0; i < parameters.length; i++) {
            preparedStatement.setObject(i + 1, parameters[i]);
        }
    }
}
