package com.imcode.db.mock;

import com.imcode.db.DatabaseConnection;
import com.imcode.db.mock.MockConnection;
import com.imcode.db.mock.MockDatabase;
import org.apache.commons.dbutils.ResultSetHandler;

import java.sql.Connection;

public class MockDatabaseConnection implements DatabaseConnection {

    private MockDatabase database;

    public MockDatabaseConnection( MockDatabase mockDatabase ) {
        this.database = mockDatabase ;
    }

    public Number executeUpdateAndGetGeneratedKey( String sql, Object[] parameters ) {
        return (Number)database.getResultForSqlCall( sql, parameters ) ;
    }

    public Object executeQuery( String sqlQuery, Object[] parameters,
                                ResultSetHandler resultSetHandler ) {
        return database.executeQuery(sqlQuery, parameters, resultSetHandler) ;
    }

    public Connection getConnection() {
        return new MockConnection(database) ;
    }

    public int executeUpdate( String sql, Object[] parameters ) {
        return database.executeUpdate( sql, parameters );
    }
}
