package com.imcode.db.handlers;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;

public class CollectionHandler extends RowTransformingHandler {

    private Collection collection ;

    public CollectionHandler(Collection collection, RowTransformer objectFromRowFactory) {
        super(objectFromRowFactory) ;
        this.collection = collection;
    }

    public Object handle(ResultSet resultSet) throws SQLException {
        while ( resultSet.next() ) {
            collection.add(( (RowTransformingHandler) this ).rowTransformer.createObjectFromResultSetRow(resultSet));
        }
        return collection ;
    }
}
