package com.imcode.db.commands;

import com.imcode.db.DatabaseCommand;
import com.imcode.db.DatabaseConnection;
import com.imcode.db.DatabaseException;

public class SqlUpdateCommand implements DatabaseCommand {

    private final String sql;
    private final Object[] parameters;

    public SqlUpdateCommand( String sql, Object[] parameters ) {
        this.sql = sql;
        this.parameters = parameters;
    }

    public Object executeOn( DatabaseConnection connection ) throws DatabaseException {
        return new Integer( connection.executeUpdate( sql, parameters ) );
    }
}
