package com.imcode.db;

import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;

import java.sql.Connection;
import java.sql.SQLException;

public class JdbcDatabaseConnection implements DatabaseConnection {

    private Connection connection;
    private QueryRunner queryRunner = new QueryRunner();

    public JdbcDatabaseConnection(Connection connection) {
        this.connection = connection;
    }

    public int executeUpdate(String sql, Object[] parameters) throws DatabaseException {
        try {
            return queryRunner.update(getConnection(), sql, parameters);
        } catch ( SQLException se) {
            throw DatabaseException.fromSQLException(se);
        }
    }

    public Number executeUpdateAndGetGeneratedKey(String sql, Object[] parameters) throws DatabaseException {
        try {
            return JdbcUtils.executeUpdateAndGetGeneratedKey(getConnection(), sql, parameters);
        } catch (SQLException se) {
            throw DatabaseException.fromSQLException(se);
        }
    }

    public Object executeQuery(String sqlQuery, Object[] parameters,
                               ResultSetHandler resultSetHandler) throws DatabaseException {
        try {
            return queryRunner.query(getConnection(), sqlQuery, parameters, resultSetHandler);
        } catch (SQLException e) {
            throw DatabaseException.fromSQLException(e);
        }
    }

    public Connection getConnection() {
        return connection;
    }
}
