package com.imcode.db;

import java.sql.SQLException;

import com.imcode.db.exceptions.IntegrityConstraintViolationException;
import com.imcode.db.exceptions.StringTruncationException;
import org.apache.commons.lang.StringUtils;

public class DatabaseException extends RuntimeException {

    public DatabaseException( String message, Throwable ex ) {
        super( message, ex ) ;
    }

    public static DatabaseException fromSQLException( SQLException cause ) {
        return fromSQLException(null, cause) ;
    }

    public static DatabaseException fromSQLException( String message, SQLException cause ) {
        DatabaseException result ;
        String sqlState = cause.getSQLState();
        if (null == sqlState) {
            if (null == message) {
                message = cause.getMessage() ;
            }
            result = new DatabaseException(message, cause);
        } else if ( "23000".equals( sqlState ) ) {
            result = new IntegrityConstraintViolationException( message, cause );
        } else if ( "01004".equals( sqlState ) ) {
            result = new StringTruncationException( message, cause );
        } else {
            String newMessage = "SQLException with SQLState " + sqlState + ( StringUtils.isBlank(message) ? "" : ": " + message );
            result = new DatabaseException( newMessage, cause ) ;
        }
        return result ;
    }
}
