package com.imcode.db;

import com.imcode.db.DatabaseConnection;
import com.imcode.db.DatabaseException;
import org.apache.commons.dbutils.ResultSetHandler;

import java.sql.Connection;

public class DatabaseConnectionWrapper implements DatabaseConnection {

    private final DatabaseConnection connection;

    public DatabaseConnectionWrapper(DatabaseConnection connection) {
        this.connection = connection;
    }

    public int executeUpdate(String sql, Object[] parameters) throws DatabaseException {
        return connection.executeUpdate(sql, parameters) ;
    }

    public Number executeUpdateAndGetGeneratedKey(String sql, Object[] parameters) throws DatabaseException {
        return connection.executeUpdateAndGetGeneratedKey(sql, parameters);
    }

    public Object executeQuery(String sqlQuery, Object[] parameters,
                               ResultSetHandler resultSetHandler) throws DatabaseException {
        return connection.executeQuery(sqlQuery, parameters, resultSetHandler) ;
    }

    public Connection getConnection() {
        return connection.getConnection() ;
    }
}
