package com.imcode.db;

import javax.sql.DataSource;
import java.sql.Connection;
import java.sql.SQLException;

public class DataSourceDatabase implements Database {

    private DataSource dataSource;

    public DataSourceDatabase( DataSource dataSource ) {
        this.dataSource = dataSource;
    }


    public Object execute( final DatabaseCommand databaseCommand ) throws DatabaseException {
        try {
            Connection connection = dataSource.getConnection();
            try {
                DatabaseConnection defaultDatabaseConnection = new JdbcDatabaseConnection( connection );
                return databaseCommand.executeOn( defaultDatabaseConnection );
            } finally {
                connection.close() ;
            }
        } catch ( SQLException e ) {
            throw DatabaseException.fromSQLException( e );
        }
    }
    
    public Object executeCommand( final DatabaseCommand databaseCommand ) throws DatabaseException {
        return execute(databaseCommand) ;
    }

}
