/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.db;

import com.imcode.db.Database;
import com.imcode.db.DatabaseCommand;
import com.imcode.db.DatabaseConnection;
import com.imcode.db.DatabaseException;
import com.imcode.db.JdbcUtils;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;

public class DatasourceDatabase
implements Database {
    private QueryRunner queryRunner = new QueryRunner();
    private DataSource dataSource;

    public DatasourceDatabase(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object executeCommand(DatabaseCommand databaseCommand) throws DatabaseException {
        try {
            Connection connection = this.dataSource.getConnection();
            try {
                DatabaseConnectionImpl defaultDatabaseConnection = new DatabaseConnectionImpl(connection, this.queryRunner);
                Object object = databaseCommand.executeOn(defaultDatabaseConnection);
                return object;
            }
            catch (DatabaseException e) {
                throw new DatabaseException("Executing " + databaseCommand, e);
            }
            finally {
                connection.close();
            }
        }
        catch (SQLException e) {
            throw DatabaseException.fromSQLException(null, e);
        }
    }

    private static class DatabaseConnectionImpl
    implements DatabaseConnection {
        private Connection connection;
        private QueryRunner queryRunner;

        private DatabaseConnectionImpl(Connection connection, QueryRunner queryRunner) {
            this.connection = connection;
            this.queryRunner = queryRunner;
        }

        public int executeUpdate(String sql, Object[] parameters) throws DatabaseException {
            try {
                return this.queryRunner.update(this.connection, sql, parameters);
            }
            catch (SQLException se) {
                throw DatabaseException.fromSQLException(null, se);
            }
        }

        public Number executeUpdateAndGetGeneratedKey(String sql, Object[] parameters) throws DatabaseException {
            try {
                return JdbcUtils.executeUpdateAndGetGeneratedKey(this.connection, sql, parameters);
            }
            catch (SQLException se) {
                throw DatabaseException.fromSQLException(null, se);
            }
        }

        public Object executeQuery(String sqlQuery, Object[] parameters, ResultSetHandler resultSetHandler) throws DatabaseException {
            try {
                return this.queryRunner.query(this.connection, sqlQuery, parameters, resultSetHandler);
            }
            catch (SQLException e) {
                throw DatabaseException.fromSQLException(null, e);
            }
        }

        public Connection getConnection() {
            return this.connection;
        }
    }
}

