/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.db.mock;

import com.imcode.db.Database;
import com.imcode.db.DatabaseCommand;
import com.imcode.db.DatabaseException;
import com.imcode.db.mock.MockDatabaseConnection;
import com.imcode.db.mock.MockResultSet;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.Assert;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

public class MockDatabase
implements Database {
    private List sqlCalls = new ArrayList();
    private List expectedSqlCalls = new ArrayList();

    public int executeUpdate(String sqlStr, Object[] parameters) {
        this.getResultForSqlCall(sqlStr, parameters);
        return 0;
    }

    public Object executeQuery(String sqlQuery, Object[] parameters, ResultSetHandler resultSetHandler) {
        ResultSet resultSet = (ResultSet)this.getResultForSqlCall(sqlQuery, parameters);
        if (null == resultSet) {
            resultSet = new MockResultSet(new Object[0][]);
        }
        try {
            return resultSetHandler.handle(resultSet);
        }
        catch (SQLException e) {
            throw DatabaseException.fromSQLException("", e);
        }
    }

    public Object executeCommand(DatabaseCommand databaseCommand) throws DatabaseException {
        return databaseCommand.executeOn(new MockDatabaseConnection(this));
    }

    public void addExpectedSqlCall(final SqlCallPredicate sqlCallPredicate, final Object result) {
        this.expectedSqlCalls.add(new Map.Entry(){

            public Object getKey() {
                return sqlCallPredicate;
            }

            public Object getValue() {
                return result;
            }

            public Object setValue(Object value) {
                throw new UnsupportedOperationException();
            }

            public String toString() {
                return sqlCallPredicate + ": " + result;
            }
        });
    }

    public void assertExpectedSqlCalls() {
        if (!this.expectedSqlCalls.isEmpty()) {
            Assert.fail((String)("Remaining expected sql calls: " + this.expectedSqlCalls.toString()));
        }
    }

    public int getSqlCallCount() {
        return this.sqlCalls.size();
    }

    Object getResultForSqlCall(String sql, Object[] params) {
        Map.Entry entry;
        SqlCallPredicate predicate;
        SqlCall sqlCall = new SqlCall(sql, params);
        this.sqlCalls.add(sqlCall);
        Object result = null;
        if (!this.expectedSqlCalls.isEmpty() && (predicate = (SqlCallPredicate)(entry = (Map.Entry)this.expectedSqlCalls.get(0)).getKey()).evaluateSqlCall(sqlCall)) {
            result = entry.getValue();
            this.expectedSqlCalls.remove(0);
        }
        return result;
    }

    public void assertCalled(SqlCallPredicate predicate) {
        this.assertCalled(null, predicate);
    }

    public void assertCalledInOrder(SqlCallPredicate[] sqlCallPredicates) {
        SqlCall sqlCall;
        int sqlCallPredicatesIndex = 0;
        Iterator iterator = this.sqlCalls.iterator();
        while (iterator.hasNext() && (!sqlCallPredicates[sqlCallPredicatesIndex].evaluateSqlCall(sqlCall = (SqlCall)iterator.next()) || ++sqlCallPredicatesIndex != sqlCallPredicates.length)) {
        }
        if (sqlCallPredicatesIndex < sqlCallPredicates.length) {
            String failureMessage = "Expected sql call \"" + sqlCallPredicates[sqlCallPredicatesIndex].getFailureMessage() + "\"";
            if (sqlCallPredicatesIndex > 0) {
                failureMessage = failureMessage + " after sql call \"" + sqlCallPredicates[sqlCallPredicatesIndex - 1] + "\"";
            }
            Assert.fail((String)failureMessage);
        }
    }

    public void assertCalled(String message, SqlCallPredicate predicate) {
        if (!this.called(predicate)) {
            String messagePrefix = null == message ? "" : message + " ";
            Assert.fail((String)(messagePrefix + "Expected at least one sql call: " + predicate.getFailureMessage()));
        }
    }

    private boolean called(SqlCallPredicate predicate) {
        return CollectionUtils.exists((Collection)this.sqlCalls, (Predicate)predicate);
    }

    public void assertNotCalled(SqlCallPredicate sqlCallPredicate) {
        this.assertNotCalled(null, sqlCallPredicate);
    }

    public void assertNotCalled(String message, SqlCallPredicate predicate) {
        if (this.called(predicate)) {
            String messagePrefix = null == message ? "" : message + " ";
            Assert.fail((String)(messagePrefix + "Got unexpected sql call: " + predicate.getFailureMessage()));
        }
    }

    public void assertCallCount(int expectedCount, SqlCallPredicate predicate) {
        int actualCount = CollectionUtils.countMatches((Collection)this.sqlCalls, (Predicate)predicate);
        if (expectedCount != actualCount) {
            Assert.fail((String)("Expected " + expectedCount + ", but got " + actualCount + " sql calls: " + predicate.getFailureMessage()));
        }
    }

    public static class DeleteFromTableSqlCallPredicate
    extends MatchesRegexSqlCallPredicate {
        private String tableName;

        public DeleteFromTableSqlCallPredicate(String tableName) {
            super("^delete\\s+from\\s+\\b" + tableName + "\\b");
            this.tableName = tableName;
        }

        String getFailureMessage() {
            return "delete from " + this.tableName;
        }
    }

    public static class EqualsWithParametersSqlCallPredicate
    extends EqualsSqlCallPredicate {
        private String[] parameters;

        public EqualsWithParametersSqlCallPredicate(String sql, String[] parameters) {
            super(sql);
            this.parameters = parameters;
        }

        boolean evaluateSqlCall(SqlCall sqlCall) {
            return super.evaluateSqlCall(sqlCall) && Arrays.equals(this.parameters, sqlCall.getParameters());
        }

        String getFailureMessage() {
            return super.getFailureMessage() + " with parameters " + ArrayUtils.toString((Object)this.parameters);
        }
    }

    public static class StartsWithSqlCallPredicate
    extends SqlCallPredicate {
        private String prefix;

        public StartsWithSqlCallPredicate(String prefix) {
            this.prefix = prefix;
        }

        boolean evaluateSqlCall(SqlCall sqlCall) {
            return sqlCall.getString().startsWith(this.prefix);
        }

        String getFailureMessage() {
            return "start with " + this.prefix;
        }
    }

    public static class EqualsSqlCallPredicate
    extends SqlCallPredicate {
        String sql;

        public EqualsSqlCallPredicate(String sql) {
            this.sql = sql;
        }

        boolean evaluateSqlCall(SqlCall sqlCall) {
            return this.sql.equalsIgnoreCase(sqlCall.getString());
        }

        String getFailureMessage() {
            return "sql \"" + this.sql + "\"";
        }
    }

    public static class MatchesRegexSqlCallPredicate
    extends SqlCallPredicate {
        private String regex;

        public MatchesRegexSqlCallPredicate(String regex) {
            this.regex = regex;
        }

        boolean evaluateSqlCall(SqlCall sqlCall) {
            Pattern pattern = Pattern.compile(this.regex, 2);
            Matcher matcher = pattern.matcher(sqlCall.getString());
            return matcher.find();
        }

        String getFailureMessage() {
            return "Expected call to match regex " + this.regex;
        }
    }

    public static class InsertIntoTableWithParameterSqlCallPredicate
    extends InsertIntoTableSqlCallPredicate {
        private String parameter;

        public InsertIntoTableWithParameterSqlCallPredicate(String tableName, String parameter) {
            super(tableName);
            this.parameter = parameter;
        }

        boolean evaluateSqlCall(SqlCall sqlCall) {
            return super.evaluateSqlCall(sqlCall) && ArrayUtils.contains((Object[])sqlCall.getParameters(), (Object)this.parameter);
        }

        String getFailureMessage() {
            return super.getFailureMessage() + " with one parameter = \"" + this.parameter + "\"";
        }
    }

    public static class InsertIntoTableSqlCallPredicate
    extends MatchesRegexSqlCallPredicate {
        private String tableName;

        public InsertIntoTableSqlCallPredicate(String tableName) {
            super("^insert\\s+(?:into\\s+)?\\b" + tableName + "\\b");
            this.tableName = tableName;
        }

        String getFailureMessage() {
            return "insert into table " + this.tableName;
        }
    }

    public static class UpdateTableSqlCallPredicate
    extends SqlCallPredicate {
        private String tableName;
        private Object parameter;

        public UpdateTableSqlCallPredicate(String tableName, Object parameter) {
            this.tableName = tableName;
            this.parameter = parameter;
        }

        boolean evaluateSqlCall(SqlCall sqlCall) {
            boolean stringMatchesUpdateTableName = Pattern.compile("^update\\s+\\b" + this.tableName + "\\b").matcher(sqlCall.getString().toLowerCase()).find();
            boolean parametersContainsParameter = ArrayUtils.contains((Object[])sqlCall.getParameters(), (Object)this.parameter);
            return stringMatchesUpdateTableName && parametersContainsParameter;
        }

        String getFailureMessage() {
            return "update of table " + this.tableName + " with one parameter = " + this.parameter;
        }
    }

    public static abstract class SqlCallPredicate
    implements Predicate {
        public final boolean evaluate(Object object) {
            return this.evaluateSqlCall((SqlCall)object);
        }

        abstract boolean evaluateSqlCall(SqlCall var1);

        abstract String getFailureMessage();

        public String toString() {
            return this.getFailureMessage();
        }
    }

    public static class SqlCall {
        private String string;
        private Object[] parameters;

        public SqlCall(String string, Object[] parameters) {
            this.string = string;
            this.parameters = parameters;
        }

        public String getString() {
            return this.string;
        }

        public Object[] getParameters() {
            return this.parameters;
        }

        public String toString() {
            return this.getString() + " " + StringUtils.join((Object[])this.getParameters(), (String)", ");
        }
    }
}

