/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.db;

import com.imcode.db.exceptions.IntegrityConstraintViolationException;
import com.imcode.db.exceptions.StringTruncationException;
import java.sql.SQLException;

public class DatabaseException
extends RuntimeException {
    public DatabaseException(String message, Throwable ex) {
        super(message, ex);
    }

    public static DatabaseException fromSQLException(String message, SQLException cause) {
        String sqlState = cause.getSQLState();
        DatabaseException result = "23000".equals(sqlState) ? new IntegrityConstraintViolationException(message, cause) : ("01004".equals(sqlState) ? new StringTruncationException(message, cause) : new DatabaseException("SQLException with SQLState " + sqlState + ": " + message, cause));
        result.setStackTrace(cause.getStackTrace());
        return result;
    }
}

