package com.imcode.db;

import java.sql.SQLException;

import com.imcode.db.exceptions.IntegrityConstraintViolationException;
import com.imcode.db.exceptions.StringTruncationException;

public class DatabaseException extends RuntimeException {

    public DatabaseException( String message, Throwable ex ) {
        super( message, ex ) ;
    }

    public static DatabaseException fromSQLException( String message, SQLException cause ) {
        DatabaseException result ;
        String sqlState = cause.getSQLState();
        if ( "23000".equals( sqlState ) ) {
            result = new IntegrityConstraintViolationException( message, cause );
        } else if ( "01004".equals( sqlState ) ) {
            result = new StringTruncationException( message, cause );
        } else {
            result = new DatabaseException( "SQLException with SQLState " + sqlState+": "+message, cause ) ;
        }
        result.setStackTrace( cause.getStackTrace() );
        return result ;
    }
}
